/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.atf.compatibility.php.core.modules;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.util.WebResource;

public class PHPDeployableObjectAdapterUtil {

	static String INFO_DIRECTORY = "WEB-INF"; //$NON-NLS-1$

	public static IModuleArtifact getModuleObject(Object obj) {
		IResource resource = null;
		IProject project = null;
		if (obj instanceof IResource) {
			resource = (IResource) obj;
			project = resource.getProject();
		}
		else if (obj instanceof IAdaptable){
			resource = (IResource) ((IAdaptable) obj).getAdapter(IResource.class);
			if (resource == null) return null;
			project = resource.getProject();
		}	
		else if (resource instanceof IProject) {
			project = (IProject) resource;			
		}

		if (project != null && !hasInterestedComponents(project))
			return null;
		
		return new WebResource(getModule(project), new Path("")); //$NON-NLS-1$
	}

	protected static IModule getModule(IProject project) {
		if (hasInterestedComponents(project))
			return ServerUtil.getModule(project);
		return null;
	}
	
	protected static boolean hasInterestedComponents(IProject project) {
		try {
			return project.hasNature(PHPConstants.PHPNATURE_ID);
		} catch (CoreException e) {
			return false;
		}
	}
	
}
