/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.atf.adapter;

import java.util.HashMap;
import java.util.Iterator;

import org.eclipse.atf.core.CorePlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class WebResourceLocatorAdapterFactory implements IAdapterFactory {

	protected static final Class [] ADAPTER_LIST = { IWebResourceLocator.class };
	
	//extension support
	protected static final String LOCATOR_PLUGIN_POINT = "webResourceLocator";
	
	protected static final String TAG_LOCATOR = "locator";
	protected static final String ATTR_CLASS = "class";

	protected static final String TAG_NATURE = "nature";
	protected static final String ATTR_ID = "id";
	
	//map of nature ID's to configuration element
	protected HashMap locatorMap = null;
	
	public Object getAdapter(final Object adaptableObject, Class adapterType) {

		if( adapterType == IWebResourceLocator.class && adaptableObject instanceof IProject){
			
			IProject project = (IProject)adaptableObject;
			
			try{
				IWebResourceLocator locator = getLocator( project );
				//return a default locator if none is available
				if( locator == null )
					locator = new BaseWebResourceLocator();
				
				locator.setProject(project);
				return locator;
			}
			catch( CoreException ce ){
				ce.printStackTrace();
				return null;
			}		
		}
		else{
			return null;
		}
	}
	
	protected IWebResourceLocator getLocator( IProject project ) throws CoreException{
		IWebResourceLocator locator = null;
		
		if( locatorMap == null )
			loadExtensions();
		
		for (Iterator natureIter = locatorMap.keySet().iterator(); natureIter.hasNext();) {
			String natureId = (String) natureIter.next();
			
			if( project.hasNature(natureId) ){
				IConfigurationElement confElement = (IConfigurationElement)locatorMap.get(natureId);
				locator = (IWebResourceLocator) confElement.createExecutableExtension(ATTR_CLASS);
				break;
			}
			
		}
				
		return locator;
	}
	
	protected void loadExtensions(){
		locatorMap = new HashMap();
		
		IExtensionRegistry registry = Platform.getExtensionRegistry();
		IExtensionPoint point = registry.getExtensionPoint(CorePlugin.PLUGIN_ID, 
				LOCATOR_PLUGIN_POINT);
		
		if (point == null)
			return;
		IExtension[] extensions = point.getExtensions();
		for (int i = 0; i < extensions.length; i++) {
			IConfigurationElement[] elements = extensions[i].getConfigurationElements();
			for (int j = 0; j < elements.length; j++) {
				if (elements[j].getName().equals(TAG_LOCATOR)) {
					String natureId = elements[j].getChildren(TAG_NATURE)[0].getAttribute(ATTR_ID);
					locatorMap.put( natureId, elements[j]);
				}
			}
		}
	}

	public Class[] getAdapterList() {
		return ADAPTER_LIST;
	}

}
