/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.atf.facet;

import org.eclipse.atf.core.CorePlugin;
import org.eclipse.atf.natures.ATFNature;
import org.eclipse.atf.project.ProjectUtils;
import org.eclipse.atf.runtime.RuntimeManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class ATFFacetInstallDelegate implements IDelegate
{
	public void execute( IProject project, IProjectFacetVersion fv,
			Object config, IProgressMonitor monitor ) throws CoreException
	{
		if ( monitor == null )
			monitor = new NullProgressMonitor();

		monitor.beginTask( "Adding facet...", 100 );
		
		try
		{			
			monitor.subTask( "Adding nature..." );
			SubProgressMonitor sub = new SubProgressMonitor( monitor, 15 );
			
			try{
				ATFNature.addNature( project, sub );
			}
			catch( CoreException e ){
				monitor.done();
				throw new CoreException( new Status(
						IStatus.ERROR,
						CorePlugin.PLUGIN_ID,
						IStatus.OK,
						"Error installing runtime! ATF Nature could not be added..", e) );
			}
			
			
			// get selected toolkit from wizard
			final ATFFacetInstallConfig cfg = (ATFFacetInstallConfig) config;
			Object[] toolkits = cfg.getToolkits();

			// install JS toolkit
			sub = new SubProgressMonitor( monitor, 80 );
			sub.setTaskName( "Installing toolkits..." );
			RuntimeManager.getInstance().installRuntimes( toolkits, project, sub );

			// store the settings in the project
			monitor.subTask( "Saving settings..." );
			ProjectUtils.saveSettings( project, toolkits );
			monitor.worked( 5 );
		}
		catch ( Exception e )
		{
			throw new CoreException( new Status( IStatus.ERROR,
					CorePlugin.PLUGIN_ID, IStatus.ERROR,
					"Error installing runtime!", e ) );
		}
		finally
		{
			monitor.done();
		}
	}

}
