/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.atf.facet;

import org.eclipse.atf.core.CorePlugin;
import org.eclipse.atf.natures.ATFNature;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class ATFFacetUninstallDelegate implements IDelegate
{
	public void execute( IProject project, IProjectFacetVersion fv,
			Object config, IProgressMonitor monitor ) throws CoreException
	{
		if ( monitor == null )
			monitor = new NullProgressMonitor();

		monitor.beginTask( "Removing facet...", 100 );
		
		try
		{
			/*
			 * @GINO: Need to decide if what we will do with the AJAX Runtimes that are installed in the
			 * project if we disable the ATF Facet.
			 * 
			 * For now all we'll do is remove the ATF nature
			 */
			
			/*
			monitor.worked( 10 );
			RuntimeManager manager = RuntimeManager.getInstance();

			// uninstall JS toolkit
			SubProgressMonitor sub = new SubProgressMonitor( monitor, 80 );
			sub.setTaskName( "Uninstalling toolkit..." );
			manager.uninstallRuntime( project, monitor );
			*/
			
			monitor.subTask( "Removing nature..." );
			SubProgressMonitor sub = new SubProgressMonitor( monitor, 100 );
			
			try{
				//remove the nature from the project (this also clears the settings on the project)
				ATFNature.removeNature( project, sub );
			}
			catch( CoreException e ){
				monitor.done();
				throw new CoreException( new Status(
						IStatus.ERROR,
						CorePlugin.PLUGIN_ID,
						IStatus.OK,
						"Error uninstalling runtime! ATFNature could not be removed...", e) );
			}
		}
		catch ( Exception e )
		{
			throw new CoreException( new Status( IStatus.ERROR,
					CorePlugin.PLUGIN_ID, IStatus.ERROR,
					"Error uinstalling runtime!", e ) );
		}
		finally
		{
			monitor.done();
		}
	}
}
