/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/


package org.eclipse.atf.natures;

import org.eclipse.atf.runtime.IRuntime;
import org.eclipse.atf.runtime.handler.IRuntimeHandler;
import org.eclipse.atf.runtime.handler.SimpleRuntimeHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.QualifiedName;

/*
 * The ATF RuntimeAwareNature is meant to be subclass for each AJAX
 * Runtime Type (i.e. Dojo, Rico, Zimbra...). It is used to store
 * information about a particular runtime.
 */
public abstract class RuntimeAwareNature extends PlatformObject implements IProjectNature, IExecutableExtension {

	private IProject project = null;
	
	protected final static String RUNTIME_PROP = "runtime";
	
	/*
	 * subclassed can override to handle default situations. (if none is provided through the XML)
	 */
	public IRuntimeHandler getDefaultRuntimeHandler( IRuntime runtime ){
		return new SimpleRuntimeHandler();
	}
	
	//used for storing qualified preferences
	abstract public String getPrefixId();
	
	public String [] getAssociatedBuilderIds(){
		return new String[] {};
	}
	
//	public void saveRuntimeSettings( IRuntimeInstance runtimeInstance ) throws CoreException{
//		project.setPersistentProperty( new QualifiedName(getPrefixId(), RUNTIME_PROP ), RuntimeManager.getInstance().serializeRuntimeInstance(runtimeInstance) );		
//	}
//	
//	//Returns a temporary instance that is not added to the Runtime.
//	public IRuntimeInstance loadRuntimeSettings( IRuntime runtime ) throws CoreException{
//		//lookup the instance in the project
//		String runtimeSettings = getProject().getPersistentProperty( new QualifiedName(getPrefixId(), RUNTIME_PROP ) );
//		
//		if( runtimeSettings != null ){
//			
//			//parse the settings and create a RuntimeInstance object
//			Element runtimeSettingElm = null;	
//			
//			InputStream stream = null;
//			try {
//				stream = new BufferedInputStream( new ByteArrayInputStream(runtimeSettings.getBytes("UTF8")) );
//				DocumentBuilder parser= DocumentBuilderFactory.newInstance().newDocumentBuilder();
//				parser.setErrorHandler(new DefaultHandler());
//				runtimeSettingElm = parser.parse(new InputSource(stream)).getDocumentElement();
//			
//			} catch ( Exception e) {
//				if( stream != null ){
//					try {
//						stream.close();
//					} catch (IOException e1) {
//						// TODO Auto-generated catch block
//						e1.printStackTrace();
//					}
//				}
//				throw new CoreException( new Status(
//						IStatus.ERROR,
//						CorePlugin.PLUGIN_ID,
//						IStatus.ERROR,
//						"Could not parse Runtime settings.", e) );
//				
//			} finally {
//				if( stream != null ){
//					try {
//						stream.close();
//					} catch (IOException e) {
//						// TODO Auto-generated catch block
//						e.printStackTrace();
//					}
//				}
//			}
//			
//			RuntimeManager manager = RuntimeManager.getInstance();
//			
//			//creating form the XML settings
//			/*
//			 * Since this instance is created just to be able to uninstall the Runtime from the Project, it is not
//			 * added to the Runtime object. This should be considered a temporary instance.
//			 */
//			IRuntimeInstance runtimeInstance = manager.createRuntimeInstance( runtimeSettingElm, false );
//			
//			if( runtimeInstance != null ){
//				return runtimeInstance;
//			}
//			else{
//				throw new CoreException( new Status(
//						IStatus.ERROR,
//						CorePlugin.PLUGIN_ID,
//						IStatus.ERROR,
//						"No Runtime instance defined for runtimeType <"+runtime.getId()+">.", null) );
//				
//			}
//			
//		}
//		else{
//			throw new CoreException( new Status(
//					IStatus.ERROR,
//					CorePlugin.PLUGIN_ID,
//					IStatus.ERROR,
//					"No Runtime settings found for project.", null) );
//		}
//	}
//	
	public void clearRuntimeSettings() throws CoreException{
		project.setPersistentProperty( new QualifiedName(getPrefixId(), RUNTIME_PROP ), null );		
	}
	
	public void configure() throws CoreException {
		//configure builders
		String[] builderIds = getAssociatedBuilderIds();
		if(builderIds != null) {
			for(int i=0; i<builderIds.length; i++) {
				NatureUtil.addBuilder(getProject(), builderIds[i]);
			}
		}
	}
	
	public void deconfigure() throws CoreException {
		clearRuntimeSettings();
		
		//deconfigure builders
		String[] builderIds = getAssociatedBuilderIds();
		if(builderIds != null) {
			for(int i=0; i<builderIds.length; i++) {
				NatureUtil.removeBuilder(getProject(), builderIds[i]);
			}
		}
	}
	
	public IProject getProject() {
		return project;
	}

	public void setProject(IProject project) {
		this.project = project;
		
	}
	
	/* IExecutableExtension Implementation */
	public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException{
		
	}
}