/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/


package org.eclipse.atf.resources;

import org.eclipse.atf.core.CorePlugin;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;


public class ResourceChangeListener implements IResourceChangeListener {

	protected ResourceDeltaVisitor deltaVisitor;
	
	public ResourceChangeListener(ResourceDeltaVisitor deltaVisitor) {
		 this.deltaVisitor = deltaVisitor;
	}
	
	public void resourceChanged(IResourceChangeEvent event) {
		
		IResourceDelta delta = event.getDelta();
		int type = event.getType();
		try {
			if (delta != null) {
				deltaVisitor.setChangeType(type);
				delta.accept(deltaVisitor);
			}
		} catch (CoreException ce) {
			CorePlugin.log(ce); 
			ce.printStackTrace();
		}
	}

	

}
