/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.atf.runtime;

import org.eclipse.atf.runtime.installer.IRuntimeInstaller;
import org.eclipse.atf.runtime.validator.IRuntimeValidator;
import org.eclipse.atf.runtime.version.IVersionFinder;


/**
 * Interface representing a JavaScript Toolkit type (for example, Dojo or
 * Script.aculo.us).  Individual instances of a toolkit type are represented
 * by IRuntimeInstance.
 */
public interface IRuntime {

	/**
	 * Returns the fully qualified ID for this toolkit type.  For example, the
	 * Dojo toolkit would return "org.eclipse.atf.personality.dojo.core.dojo".
	 */
	String getId();

	/**
	 * Returns displayable name for this toolkit type.
	 */
	String getName();
	
	/**
	 * Returns true if the user can add new toolkit instances.  False otherwise.
	 */
	boolean isAllowUserInstances();

	/**
	 * Returns the installer for this toolkit type.  Most toolkits will use
	 * the FileCopyRuntimeInstaller, which does a simple copy.
	 */
	IRuntimeInstaller getInstaller();
	
	/**
	 * Returns the validator for this toolkit type.  The validator ensures
	 * that a given toolkit instance of this type is valid.
	 */
	IRuntimeValidator getValidator();
	
	/**
	 * Returns the version finder for this toolkit type.  The version finder
	 * is run on instances to determine the version.
	 */
	IVersionFinder getVersionFinder();
	
	/**
	 * Returns an array with all the IRuntimeInstances of this type
	 * @return
	 */
	IRuntimeInstance [] getRuntimeInstances();
	
	/**
	 * Returns true if this instance was created by the user.
	 */
	boolean isUser();
}