/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.atf.runtime;


public interface IRuntimeContainer {
	
	/**
	 * Returns an array of all the configured IRuntime.
	 * @return
	 */
	IRuntime[] getRuntimes();
	
	/**
	 * Gets the IRuntime instance with the specified type id.
	 * 
	 * @param type fully qualified id of the IRuntime instance
	 * @return
	 */
	IRuntime getRuntime( String type );
	
	/**
	 * Adds a runtime to the list of supported IRuntimes
	 * 
	 * @param runtime
	 */
	void addRuntime( IRuntime runtime );
	
	/**
	 * Removes a runtime from the list of supported IRuntimes
	 * @param runtime
	 */
	void removeRuntime( IRuntime runtime );
	
}
