/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.atf.runtime;


/**
 * Interface representing an individual instance for a JavaScript toolkit type.
 */
public interface IRuntimeInstance {

	/**
	 * Returns a string URL representing the location of this instance.  When
	 * installing an instance into a project, the toolkit files will be read
	 * from this location.
	 */
	String getLocation();

	/**
	 * Returns the type.
	 */
	IRuntime getType();

	/**
	 * Returns the version.
	 */
	String getVersion();

	/**
	 * Returns a displayable name.
	 */
	String getName();

	/**
	 * Returns true if this instance was created by the user.
	 */
	boolean isUser();

}