/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.atf.runtime.validator;

import org.eclipse.atf.runtime.IRuntimeInstance;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/**
 * This class is the default validator for when no validator is defined. It simply
 * always return a valid response (OK).
 * 
 * @author Gino Bustelo
 *
 */
public final class AlwaysValidRuntimeValidator implements IRuntimeValidator {

	public IStatus validate(IRuntimeInstance instance) {
		return Status.OK_STATUS;
	}

}
