/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.atf.runtime.version;

import org.eclipse.atf.runtime.IRuntimeInstance;

/**
 * 
 * This inteface is used to implement a strategy for discovering the version of
 * an IRuntimeInstance.
 * 
 * @author Gino Bustelo
 */
public interface IVersionFinder {
	
	/**
	 * This method is called to find a version number in the specified
	 * IRuntimeInstance.
	 * 
	 * A returned null means that the version could not be found.
	 * 
	 * @param instance IRuntimeInstance to inspect for a version id
	 * @return
	 */
	String findVersion(IRuntimeInstance instance);
}
