/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
/*
 * Created on Mar 29, 2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package org.eclipse.atf.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.StringTokenizer;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/**
 * @author Don Sedota
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class ErrorStatusUtilities {

	public static MultiStatus createMultiStatusFromException(Exception e, Class clz, String pluginId, String message) {
		
		MultiStatus multiStatus = new MultiStatus(pluginId, IStatus.ERROR, message, null);
		Status eStatus = new Status(IStatus.ERROR, pluginId, IStatus.ERROR, "Received exception in class " + clz.getName() + " of type " + e.getClass().getName() + ": ", e);
		multiStatus.add(eStatus);
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		PrintStream ps = new PrintStream(baos);
		e.printStackTrace(ps);
		StringTokenizer strTok = new StringTokenizer(baos.toString(), "\n\t\r", false);
		while(strTok.hasMoreElements()) {
			Status stackElementStatus = new Status(IStatus.ERROR, pluginId, IStatus.ERROR, "    " + strTok.nextToken(), e);
			multiStatus.add(stackElementStatus);
		}
		try {
			baos.close();
		}
		catch(IOException ex) {
			ex.printStackTrace();
		}
		ps.close();
		return multiStatus;
	}


}
