/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/


package org.eclipse.atf.generator;

import java.net.MalformedURLException;
import java.net.URL;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/**
 * The plug-in runtime class for the AjaxNature plug-in.
 */
public class GeneratorPlugin extends AbstractUIPlugin
{

  /**
   * The single instance of this plug-in runtime class.
   */
  private static GeneratorPlugin sPlugin = null;
  
  public static String PLUGIN_ID = "org.eclipse.atf.generator";

  /**
   * @param descriptor
   */
  public GeneratorPlugin()
  {
    sPlugin = this;
  }

  public static ImageDescriptor getImageDescriptor(String name)
  {
    try
    {
      String base = getDefault().getBundle().getEntry("/").toString();
      String uri = base + name;
      return ImageDescriptor.createFromURL(new URL(uri));

    }
    catch (MalformedURLException e)
    {
      return ImageDescriptor.getMissingImageDescriptor();
    }
  }

  public static GeneratorPlugin getDefault()
  {
    return sPlugin;
  }

  public static Shell getActiveWorkbenchShell()
  {
    IWorkbenchWindow workBenchWindow = getActiveWorkbenchWindow();
    if (workBenchWindow == null)
    {
      return null;
    }
    return workBenchWindow.getShell();
  }

  /**
   * Returns the active workbench window
   * 
   * @return the active workbench window
   */
  public static IWorkbenchWindow getActiveWorkbenchWindow()
  {
    if (sPlugin == null)
    {
      return null;
    }
    IWorkbench workBench = sPlugin.getWorkbench();
    if (workBench == null)
    {
      return null;
    }
    return workBench.getActiveWorkbenchWindow();
  }

  public static IWorkbenchPage getActivePage()
  {
    IWorkbenchWindow activeWorkbenchWindow = getActiveWorkbenchWindow();
    if (activeWorkbenchWindow == null)
    {
      return null;
    }
    return activeWorkbenchWindow.getActivePage();
  }

  public static String getPluginId()
  {
    return getDefault().getBundle().getSymbolicName();
  }

  public static void log(Throwable e)
  {
    log(new Status(IStatus.ERROR, getPluginId(), IStatus.ERROR, "Error", e)); //$NON-NLS-1$
  }

  public static void log(IStatus status)
  {
    getDefault().getLog().log(status);
  }
}