/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/


package org.eclipse.atf.generator.action;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

import org.eclipse.atf.generator.GeneratorPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;


public class FileCreationUtils {

	public static final String FILE_TEMPLATE_TYPE = "file";
	public static final String SNIPPET_TEMPLATE_TYPE = "snippet";
	public static final String WIZARD_ICON_TYPE = "wizard";
	public static final String TEMPLATES_DIR = "template";
	public static final String ICONS_DIR = "icons";
		
	public static String createTemplateFile(IProject project, String contents, String type, String filename) throws CoreException {
		IFolder templateFolder = project.getFolder(TEMPLATES_DIR);
		if(!templateFolder.exists())
			templateFolder.create(true, true, null);
		IFolder typeFolder = templateFolder.getFolder(type);
		if(!typeFolder.exists())
			typeFolder.create(true, true, null);
		IFile templateFile = typeFolder.getFile(filename);
		
		ByteArrayInputStream inputStream = new ByteArrayInputStream(contents.getBytes());
		if (!(templateFile.exists())) {
			templateFile.create(inputStream, true, null);
		} else {
			templateFile.setContents(inputStream, true, false, null);
		}
		try {
			inputStream.close();
		} catch(IOException e) {
			throw new CoreException(new Status(
				IStatus.ERROR,
				GeneratorPlugin.getPluginId(),
				IStatus.ERROR,
				"Error creating file template!",
				e));
		} 
		return templateFile.getProjectRelativePath().makeAbsolute().toString();
		
	}
	
	public static String createIconFile(IProject project, String sourcePath, String type) throws CoreException {
		IFolder iconsFolder = project.getFolder(ICONS_DIR);
		if(!iconsFolder.exists())
			iconsFolder.create(true, true, null);
		IFolder typeFolder = iconsFolder.getFolder(type);
		if(!typeFolder.exists())
			typeFolder.create(true, true, null);
				
		File sourceFile = new File(sourcePath);
		if(!sourceFile.exists())
			return null;
		
		IFile iconFile = typeFolder.getFile(sourceFile.getName());
		try {
			FileInputStream inputStream = new FileInputStream(sourceFile);
			if(!iconFile.exists()) {
				iconFile.create(inputStream, true, null);
			} else {
				iconFile.setContents(inputStream, true, false, null);
			}
			inputStream.close();
			
		} catch(Exception e) {
			throw new CoreException(new Status(
				IStatus.ERROR, 
				GeneratorPlugin.getPluginId(),
				IStatus.ERROR,
				"Error creating icon file!",
				e));
		} 
		return iconFile.getProjectRelativePath().toString();
	}
	
	public static void copyFileContents(File sourceFile, String sourceRootDir, IProject destinationProject, String destinationDir) throws CoreException {

		//Create destination root
		Path destinationPath = new Path(destinationDir);
		String[] segs = destinationPath.segments();
		IContainer destinationContainer = destinationProject;
		for(int i=0; i<segs.length; i++) {
			destinationContainer = destinationContainer.getFolder(new Path(segs[i]));
			if(!destinationContainer.exists()) {
				((IFolder)destinationContainer).create(true, false, null);
			}
		}
		
		//Create subdirs for file if necessary
		IPath sourceFilePath = new Path(sourceFile.getAbsolutePath());
		IPath sourceRootPath = new Path(sourceRootDir);
		sourceFilePath = sourceFilePath.removeFirstSegments(sourceFilePath.matchingFirstSegments(sourceRootPath));
		segs = sourceFilePath.segments();
		for(int i=0; i<segs.length-1; i++) {
			destinationContainer = destinationContainer.getFolder(new Path(segs[i]));
			if(!destinationContainer.exists()) {
				((IFolder)destinationContainer).create(true, false, null);
			}
		}
		
		//Copy over contents
		IFile newFile = destinationContainer.getFile(new Path(sourceFile.getName()));
		try {
			FileInputStream inputStream = new FileInputStream(sourceFile);
			if(!newFile.exists()) {
				newFile.create(inputStream, true, null);
			} else {
				newFile.setContents(inputStream, true, false, null);
			}
			inputStream.close();
			
		} catch(Exception e) {
			throw new CoreException(new Status(
				IStatus.ERROR, 
				GeneratorPlugin.getPluginId(),
				IStatus.ERROR,
				"Error creating file!",
				e));
		} 
	}
}
