/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/


package org.eclipse.atf.generator.action;

import java.util.ArrayList;

import org.eclipse.core.resources.IProject;
import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.pde.internal.ui.wizards.plugin.PluginClassCodeGenerator;
import org.eclipse.pde.internal.ui.wizards.plugin.PluginFieldData;
import org.eclipse.pde.internal.ui.wizards.templates.PluginReference;

public class RuntimePluginClassCodeGenerator extends PluginClassCodeGenerator {

	public RuntimePluginClassCodeGenerator(IProject project, String qualifiedClassName, PluginFieldData data) {
		super(project, qualifiedClassName, data, true);
	}
	
	public IPluginReference[] getDependencies() {
		IPluginReference[] pRefs = super.getDependencies();
		ArrayList result = new ArrayList();
		for(int i=0; i<pRefs.length; i++) {
			result.add(pRefs[i]);
		}
		result.add(new PluginReference("org.eclipse.core.runtime", null, 0));
		return (IPluginReference[]) result.toArray(new IPluginReference[result.size()]);
	}
}
