/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/


package org.eclipse.atf.generator.action;

import java.io.File;
import java.lang.reflect.InvocationTargetException;

import org.eclipse.atf.generator.model.MrCleanToolingInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.IProjectProvider;
import org.eclipse.pde.internal.ui.wizards.plugin.PluginFieldData;
import org.eclipse.pde.ui.IFieldData;
import org.eclipse.pde.ui.IPluginContentWizard;
import org.eclipse.pde.ui.IPluginFieldData;


public class RuntimePluginCreationOperation extends NewPluginProjectCreationOperation {

	private MrCleanToolingInfo dataModel;
	
	public RuntimePluginCreationOperation(IFieldData data, IProjectProvider provider, MrCleanToolingInfo dataModel, IPluginContentWizard contentWizard) {
		super(data, provider, contentWizard);
		this.dataModel = dataModel;
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.actions.WorkspaceModifyOperation#execute(org.eclipse.core.runtime.IProgressMonitor)
	 */
	protected void execute(IProgressMonitor monitor) throws CoreException,
			InvocationTargetException, InterruptedException {

		// start task
		monitor.beginTask(PDEUIMessages.NewProjectCreationOperation_creating,
				getNumberOfWorkUnits()); //$NON-NLS-1$
		monitor.subTask(PDEUIMessages.NewProjectCreationOperation_project); //$NON-NLS-1$

		// create project
		IProject project = createProject();
		monitor.worked(1);
		createContents(monitor, project);
		// set classpath if project has a Java nature
		if (project.hasNature(JavaCore.NATURE_ID)) {
			monitor
					.subTask(PDEUIMessages.NewProjectCreationOperation_setClasspath); //$NON-NLS-1$
			setClasspath(project, fData);
			monitor.worked(1);
		}

		if (fData instanceof IPluginFieldData) {
			IPluginFieldData data = (IPluginFieldData) fData;

			// generate top-level Java class if that option is selected
			if (data.doGenerateClass()) {
				generateTopLevelPluginClass(project, new SubProgressMonitor(
						monitor, 1));
			}
		}
		// generate the manifest file
		monitor.subTask(PDEUIMessages.NewProjectCreationOperation_manifestFile); //$NON-NLS-1$
		createManifest(project);
		monitor.worked(1);

		// generate the build.properties file
		monitor
				.subTask(PDEUIMessages.NewProjectCreationOperation_buildPropertiesFile); //$NON-NLS-1$
		createBuildPropertiesFile(project, false);
		monitor.worked(1);

		// generate content contributed by template wizards
		boolean contentWizardResult = true;
		if (fContentWizard != null) {
			contentWizardResult = fContentWizard.performFinish(project, fModel,
					new SubProgressMonitor(monitor, 1));
		}

		fModel.save();

		adjustManifests(monitor, project);
		/*if (fData.hasBundleStructure()) {
			openFile(project.getFile("META-INF/MANIFEST.MF")); //$NON-NLS-1$
		} else {
			openFile((IFile) fModel.getUnderlyingResource());
		}*/
		monitor.worked(1);

		fResult = contentWizardResult;
	}
	
	protected void createManifest(IProject project) throws CoreException {
		super.createManifest(project);
		
	}
	
	protected void fillBinIncludes(IProject project, IBuildEntry binEntry, boolean hasExtensions) throws CoreException {
		super.fillBinIncludes(project, binEntry, hasExtensions);
		binEntry.addToken("resources/"); 
		
	}
	
	protected void createContents(IProgressMonitor monitor, IProject project) throws CoreException, JavaModelException, InvocationTargetException, InterruptedException {

		//Import the runtime artifacts
		File[] resources = dataModel.getRuntimeInstanceInfo().getArtifacts();
		if(resources == null)
			return;
		String rootSourceDir = dataModel.getRuntimeInstanceInfo().getRootArtifactsLocation();
		//String resourcesSubDir = dataModel.getRuntimeInstanceInfo().getResourcesRootDirectory();
		String destinationDir = "resources/";
		//if(resourcesSubDir != null)
		//	destinationDir += resourcesSubDir+"/";
		for(int i=0; i<resources.length; i++) {
			FileCreationUtils.copyFileContents(resources[i], rootSourceDir, project, destinationDir);
		}
	}
	
	protected void generateTopLevelPluginClass(IProject project, IProgressMonitor monitor) throws CoreException {
		PluginFieldData data = (PluginFieldData) fData;
		fGenerator = new RuntimePluginClassCodeGenerator(project, data.getClassname(), data);
		fGenerator.generate(monitor);
		monitor.done();
	}
}
