/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/


package org.eclipse.atf.generator.action;

import java.util.ArrayList;

import org.eclipse.core.resources.IProject;
import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.pde.internal.ui.wizards.plugin.PluginClassCodeGenerator;
import org.eclipse.pde.internal.ui.wizards.plugin.PluginFieldData;
import org.eclipse.pde.internal.ui.wizards.templates.PluginReference;

public class UiPluginClassCodeGenerator extends PluginClassCodeGenerator {

	private String[] techPluginIncludes;
	
	public UiPluginClassCodeGenerator(IProject project, String qualifiedClassName, PluginFieldData data, String[] techPluginIncludes) {
		super(project, qualifiedClassName, data, true);
		this.techPluginIncludes = techPluginIncludes;
	}
	
	public IPluginReference[] getDependencies() {
		IPluginReference[] pRefs = super.getDependencies();
		ArrayList result = new ArrayList();
		for(int i=0; i<pRefs.length; i++) {
			result.add(pRefs[i]);
		}
		result.add(new PluginReference("org.eclipse.core.resources", null, 0));
		result.add(new PluginReference("org.eclipse.ui", null, 0));
		//result.add(new PluginReference("org.eclipse.jst.j2ee.ui", null, 0));
		result.add(new PluginReference("org.eclipse.core.runtime", null, 0));
		//result.add(new PluginReference("org.eclipse.jst.j2ee.web", null, 0));
		//result.add(new PluginReference("org.eclipse.jst.j2ee", null, 0));
		//result.add(new PluginReference("org.eclipse.jst.j2ee.core", null, 0));
		//result.add(new PluginReference("org.eclipse.wst.common.frameworks", null, 0));
		//result.add(new PluginReference("org.eclipse.wst.common.modulecore", null, 0));
		//result.add(new PluginReference("org.eclipse.jst.servlet.ui", null, 0));
		//result.add(new PluginReference("org.eclipse.wst.common.frameworks.ui", null, 0));
		//result.add(new PluginReference("org.eclipse.jface.text", null, 0));
		//result.add(new PluginReference("org.eclipse.jst.jsp.ui", null, 0));
		//result.add(new PluginReference("org.eclipse.jst.jsp.core", null, 0));
		//result.add(new PluginReference("org.eclipse.ui.ide", null, 0));
		//result.add(new PluginReference("org.eclipse.ui.editors", null, 0));
		//result.add(new PluginReference("org.eclipse.pde.ui", null, 0));
		//result.add(new PluginReference("org.eclipse.wst.web", null, 0));
		//result.add(new PluginReference("org.eclipse.wst.web.ui", null, 0));
		result.add(new PluginReference("org.eclipse.wst.common.project.facet.ui", null, 0));
		result.add(new PluginReference("org.eclipse.wst.common.project.facet.core", null, 0));
		result.add(new PluginReference("org.eclipse.atf.ui", null, 0));
		result.add(new PluginReference("org.eclipse.atf.core", null, 0));
		result.add(new PluginReference("org.eclipse.atf.templates", null, 0));
		if(techPluginIncludes != null) {
			for(int i=0; i<techPluginIncludes.length; i++) {
				result.add(new PluginReference(techPluginIncludes[i], null, 0));
			}
		}
				
		return (IPluginReference[]) result.toArray(new IPluginReference[result.size()]);
	}
}
