/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/


package org.eclipse.atf.generator.model;

import java.util.ArrayList;

public class ApplicationWizardInfo {
	private ArrayList variableGroups = new ArrayList();
	private ArrayList variableRefs = new ArrayList();
	private ArrayList viewPages = new ArrayList();
	private ArrayList fileTemplates = new ArrayList();
	
	private String wizardId;
	private String name = "";
	private String description = "";
	private String className = "";
	private String packageName = "";
		
	public ApplicationWizardInfo() {
		super();
	}
	
	public void setVariableGroups(VariableGroupInfo[] groups) {
		if(groups != null) {
			variableGroups.clear();
			for(int i=0; i<groups.length; i++) {
				variableGroups.add(groups[i]);
			}
		}
	}
	
	public VariableGroupInfo[] getVariableGroups() {
		if(variableGroups == null)
			return null;
		VariableGroupInfo[] info = new VariableGroupInfo[variableGroups.size()];
		info = (VariableGroupInfo[])variableGroups.toArray(info);
		return info;
	}
	
	public void setVariableRefs(VariableInfo[] refs) {
		if(refs != null) {
			variableRefs.clear();
			for(int i=0; i<refs.length; i++) {
				variableRefs.add(refs[i]);
			}
		}
	}
	
	public VariableInfo[] getVariableRefs() {
		if(variableRefs == null)
			return null;
		VariableInfo[] info = new VariableInfo[variableRefs.size()];
		info = (VariableInfo[])variableRefs.toArray(info);
		return info;
	}
	
	public void setViewPages(VariableViewPageInfo[] pages) {
		if(pages != null) {
			viewPages.clear();
			for(int i=0; i<pages.length; i++) {
				viewPages.add(pages[i]);
			}
		}
	}
	
	public VariableViewPageInfo[] getViewPages() {
		if(viewPages == null)
			return null;
		VariableViewPageInfo[] pages = new VariableViewPageInfo[viewPages.size()];
		pages = (VariableViewPageInfo[])viewPages.toArray(pages);
		return pages;
	}
	
	public void setFileTemplates(FileTemplateInfo[] templates) {
		if(templates != null) {
			fileTemplates.clear();
			for(int i=0; i<templates.length; i++) {
				fileTemplates.add(templates[i]);
			}
		}
	}
	
	public FileTemplateInfo[] getFileTemplates() {
		if(fileTemplates == null)
			return null;
		FileTemplateInfo[] templates = new FileTemplateInfo[fileTemplates.size()];
		templates = (FileTemplateInfo[])fileTemplates.toArray(templates);
		return templates;
	}
	
	public String getWizardId() {
		if(wizardId != null) {
			return wizardId;
		} else if(className != null && packageName != null) {
			return packageName + "." + className;
		}
		return null;
	}

	public void setWizardId(String wizardId) {
		this.wizardId = wizardId;
	}

	public String getClassName() {
		return className;
	}

	public void setClassName(String className) {
		this.className = className;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getPackageName() {
		return packageName;
	}

	public void setPackageName(String packageName) {
		this.packageName = packageName;
	}
	
}
