/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/


package org.eclipse.atf.generator.model;


public class BuilderInfo {

	private String name = null;
	private String id = null;
	private String containingPluginId = null;
	private String packageName = null;
	private String className = null;
	private String techname = null;
		
	public BuilderInfo(String techname) {
		this.techname = techname;
	}
	
	public String getBuilderID() {
		if(id != null)
			return id;
		if(techname != null)
			return techname+"Builder";
		return null;
	}
	
	public void setBuilderID(String id) {
		this.id = id;
	}
	
	public String getFullBuilderID() {
		return containingPluginId + "." + getBuilderID();
	}
	
	public String getPackageName() {
		
		if(packageName != null)
			return packageName;
		if(techname != null)
			return "com."+techname+".builders";
		return null;
		
	}
	
	public void setPackageName(String packageName) {
		this.packageName = packageName;
	}
	
	public void setContainingPluginId(String pluginID) {
		this.containingPluginId = pluginID;
	}
	
	public String getContainingPluginId() {
		return containingPluginId;
	}
	
	public String getClassName() {
		
		if(className != null)
			return className;
		if(techname != null)
			return Utils.capitalize(techname) + "Builder";
		return null;
	}
	
	public String getFullClassName() {
		if(getPackageName() != null && getClassName() != null)
			return getPackageName() + "." + getClassName();
		if(getClassName() != null)
			return getClassName();
		return null;
	}
	
	public void setClassName(String className) {
		this.className = className;
	}
	
	public String getName() {
		if(name != null)
			return name;
		if(techname != null)
			return techname + "Builder";
		return null;
	}
	
	public void setName(String name) {
		this.name = name;
	}

	public String getTechname() {
		return techname;
	}

	public void setTechname(String techname) {
		this.techname = techname;
	}
		
	
}
