/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.atf.generator.model;

public class FacetInfo {

	private String techname;
	private String id;
	private String packageName;
	private String installDelegateClass;
	private String uninstallDelegateClass;
		
	public FacetInfo(String techname) {
		this.techname = techname;
	}

	public String getInstallDelegateClass() {
		if(installDelegateClass == null) {
			installDelegateClass = Utils.capitalize(techname) + "FacetInstallDelegate";
		}
		return installDelegateClass;
	}

	public void setInstallDelegateClass(String classname) {
		this.installDelegateClass = classname;
	}

	
	public String getPackageName() {
		if(packageName != null)
			return packageName;
		if(techname != null)
			return "com."+techname+".facet";
		return null;
	}

	public void setPackageName(String packageName) {
		this.packageName = packageName;
	}

	public String getTechname() {
		return techname;
	}

	public void setTechname(String techname) {
		this.techname = techname;
	}

	public String getUninstallDelegateClass() {
		if(uninstallDelegateClass == null) {
			uninstallDelegateClass = Utils.capitalize(techname) + "FacetUninstallDelegate";
		}
		return uninstallDelegateClass;
	}

	public void setUninstallDelegateClass(String classname) {
		this.uninstallDelegateClass = classname;
	}

	public String getId() {
		if(id == null)
			return techname;
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}
	
	
}
