/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/


package org.eclipse.atf.generator.model;

import java.util.ArrayList;

public class FileTemplateInfo {
	private String name;
	private String projectRelativeLocation;
	private ArrayList creationConditions = new ArrayList();
	private String template;
	
	public FileTemplateInfo() {
		super();
	}

	public String[] getCreationConditions() {
		String[] conditions = new String[creationConditions.size()];
		conditions = (String[])creationConditions.toArray(conditions);
		return conditions;
	}

	public void setCreationConditions(String[] conditions) {
		if(conditions != null) {
			creationConditions.clear();
			for(int i=0; i<conditions.length; i++) {
				creationConditions.add(conditions[i]);
			}
		}
	}
	
	public void addCreationCondition(String condition) {
		creationConditions.add(condition);
	}
	
	public void removeCreationCondition(String condition) {
		creationConditions.remove(condition);
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getProjectRelativeLocation() {
		return projectRelativeLocation;
	}

	public void setProjectRelativeLocation(String projectRelativeLocation) {
		this.projectRelativeLocation = projectRelativeLocation;
	}

	public String getTemplate() {
		return template;
	}

	public void setTemplate(String template) {
		this.template = template;
	}
	
	
}

