/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/


package org.eclipse.atf.generator.model;

public class FileWizardInfo {
	private String className;
	private String packageName;
	private String technologyName;
	private String name;
	private String category;
	private String description;
	private String fileType;
	private String templateId;
	private String templateContextTypeId;
	private String templateDescriptorFile;
	private String templateName;
	private String templateDescription;
	private String[] resolvers;
	private String[] requiredNatures;
	
	public String getCategory() {
		return category;
	}

	public void setCategory(String category) {
		this.category = category;
	}

	public String getClassName() {
		return className;
	}

	public void setClassName(String className) {
		this.className = className;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getPackageName() {
		return packageName;
	}

	public void setPackageName(String packageName) {
		this.packageName = packageName;
	}

	public String[] getResolvers() {
		return resolvers;
	}

	public void setResolvers(String[] resolvers) {
		this.resolvers = resolvers;
	}

	public String getTechnologyName() {
		return technologyName;
	}

	public void setTechnologyName(String technologyName) {
		this.technologyName = technologyName;
	}

	public String getTemplateContextTypeId() {
		return templateContextTypeId;
	}

	public void setTemplateContextTypeId(String templateContextTypeId) {
		this.templateContextTypeId = templateContextTypeId;
	}

	public String getTemplateDescription() {
		return templateDescription;
	}

	public void setTemplateDescription(String templateDescription) {
		this.templateDescription = templateDescription;
	}

	public String getTemplateDescriptorFile() {
		return templateDescriptorFile;
	}

	public void setTemplateDescriptorFile(String templateDescriptorFile) {
		this.templateDescriptorFile = templateDescriptorFile;
	}

	public String getTemplateId() {
		return templateId;
	}

	public void setTemplateId(String templateId) {
		this.templateId = templateId;
	}

	public String getTemplateName() {
		return templateName;
	}

	public void setTemplateName(String templateName) {
		this.templateName = templateName;
	}

	public String[] getRequiredNatures() {
		return requiredNatures;
	}

	public void setRequiredNatures(String[] requiredNatures) {
		this.requiredNatures = requiredNatures;
	}
	
	public String getRequiredNaturesString() {
		if(requiredNatures == null)
			return null;
		String naturesString = "";
		for(int i=0; i<requiredNatures.length; i++) {
			naturesString += requiredNatures[i];
			if(i != (requiredNatures.length - 1))
				naturesString += ",";
		}
		return naturesString;
	}
	
	public String getJSPFileCreationPageClassName() {
		return Utils.capitalize(technologyName) + "JSPFileCreationPage";
	}
	
	public String getTemplateContextTypeClassName() {
		return "TemplateContextType"+Utils.capitalize(technologyName)+fileType;
	}

	public String getFileType() {
		return fileType;
	}

	public void setFileType(String fileType) {
		this.fileType = fileType;
	}
	
	public String getTemplatePackage() {
		return packageName + ".templates";
	}
	
	
	
	
}
