/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/


package org.eclipse.atf.generator.model;

import java.util.StringTokenizer;

import org.eclipse.atf.generator.action.FileCreationUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;


public class MrCleanToolingInfo {
	private NatureInfo natureInfo;
	private FacetInfo facetInfo;
	private BuilderInfo builderInfo;
	private ProjectWizardInfo projectInfo;
	private ApplicationWizardInfo applicationInfo;
	private RuntimeInfo runtimeInfo;
	private RuntimeInstanceInfo runtimeInstanceInfo;
	private SnippetInfo[] snippetInfo;
	private String technologyName;
	private String pluginProjectPrefix;
	private String smallIconSourcePath = "";
	private String largeIconSourcePath = "";
	private String smallIconPath = "";
	private String largeIconPath = "";
	private String coreProjectName;
	private String coreProjectPluginClass = "CorePlugin";
	private String uiProjectName;
	private String uiProjectPluginClass = "UiPlugin";
	private String j2eeProjectName;
	private String j2eeProjectPluginClass = "J2EEPlugin";
	private String staticWebProjectName;
	private String staticWebProjectPluginClass = "StaticWebPlugin";
	private String runtimeProjectName;
	private String runtimePluginClass = "RuntimePlugin";
	private boolean generateNature = false;
	private boolean generateBuilder = false;
	private boolean generateProjectWizard = false;
	private boolean generateApplicationWizard = false;
	
	public MrCleanToolingInfo() {
		super();
	}

	public ApplicationWizardInfo getApplicationWizardInfo() {
		return applicationInfo;
	}

	public void setRuntimeInfo( RuntimeInfo runtimeInfo) {
		this.runtimeInfo = runtimeInfo;
	}
	
	public RuntimeInfo getRuntimeInfo() {
		return runtimeInfo;
	}
	
	public void setRuntimeInstanceInfo( RuntimeInstanceInfo runtimeInstanceInfo) {
		this.runtimeInstanceInfo = runtimeInstanceInfo;
	}
	
	public RuntimeInstanceInfo getRuntimeInstanceInfo() {
		return runtimeInstanceInfo;
	}

	public void setApplicationWizardInfo(ApplicationWizardInfo applicationInfo) {
		this.applicationInfo = applicationInfo;
	}
	
	public SnippetInfo[] getSnippetInfo() {
		return snippetInfo;
	}
	
	public void setSnippetInfo(SnippetInfo[] snippetInfo) {
		this.snippetInfo = snippetInfo;
	}

	public BuilderInfo getBuilderInfo() {
		return builderInfo;
	}

	public void setBuilderInfo(BuilderInfo builderInfo) {
		this.builderInfo = builderInfo;
	}

	public NatureInfo getNatureInfo() {
		return natureInfo;
	}

	public void setNatureInfo(NatureInfo natureInfo) {
		this.natureInfo = natureInfo;
	}
	
	public FacetInfo getFacetInfo() {
		return facetInfo;
	}
	
	public void setFacetInfo(FacetInfo facetInfo) {
		this.facetInfo = facetInfo;
	}

	public ProjectWizardInfo getProjectWizardInfo() {
		return projectInfo;
	}

	public void setProjectWizardInfo(ProjectWizardInfo projectInfo) {
		this.projectInfo = projectInfo;
	}

	public String getTechnologyName() {
		if(technologyName != null) {
			return Utils.capitalize(technologyName).replaceAll(" ", "");
		}
		return null;
	}
	
	public String getCamelCasedTechnologyName() {
		if(technologyName != null) {
			String ccTechName = "";
			StringTokenizer strTok = new StringTokenizer(technologyName, " ");
			int i=0;
			while(strTok.hasMoreTokens()) {
				String token = strTok.nextToken();
				if(i == 0) {
					ccTechName += Utils.uncapitalize(token);
				} else {
					ccTechName += Utils.capitalize(token);
				}
				i++;
			}
			return ccTechName;
		}
		return null;
	}

	public void setTechnologyName(String technologyName) {
		this.technologyName = technologyName;
		natureInfo.setTechname(getCamelCasedTechnologyName());
		builderInfo.setTechname(getCamelCasedTechnologyName());
	}

	public boolean doGenerateBuilder() {
		return generateBuilder;
	}

	public void setGenerateBuilder(boolean generateBuilder) {
		this.generateBuilder = generateBuilder;
	}

	public boolean doGenerateNature() {
		return generateNature;
	}

	public void setGenerateNature(boolean generateNature) {
		this.generateNature = generateNature;
	}

	public String getCoreProjectName() {
		if(coreProjectName != null)
			return coreProjectName;
		if(pluginProjectPrefix != null)
			return pluginProjectPrefix+".core";
		String ccTechName = getCamelCasedTechnologyName();
		if(ccTechName != null) {
			return "com."+ccTechName+".core";
		}
		return null;
	}

	public void setCoreProjectName(String coreProjectName) {
		this.coreProjectName = coreProjectName;
	}
	
	public String getCoreProjectPluginClass() {
		return coreProjectPluginClass;
	}
	
	public void setCoreProjectPluginClass(String coreProjectPluginClass) {
		this.coreProjectPluginClass = coreProjectPluginClass;
	}
	
	public String getUiProjectName() {
		if(uiProjectName != null)
			return uiProjectName;
		if(pluginProjectPrefix != null)
			return pluginProjectPrefix+".ui";
		String ccTechName = getCamelCasedTechnologyName();
		if(ccTechName != null) {
			return "com."+ccTechName+".ui";
		}
		return null;
	}

	public void setUiProjectName(String uiProjectName) {
		this.uiProjectName = uiProjectName;
	}
	
	public String getUiProjectPluginClass() {
		return uiProjectPluginClass;
	}
	
	public void setUiProjectPluginClass(String uiProjectPluginClass) {
		this.uiProjectPluginClass = uiProjectPluginClass;
	}
	
	public String getRuntimeProjectName() {
		if(runtimeProjectName != null)
			return runtimeProjectName;
		if(pluginProjectPrefix != null)
			return pluginProjectPrefix+".runtime";
		String ccTechName = getCamelCasedTechnologyName();
		if(ccTechName != null) {
			return "com."+ccTechName+".runtime";
		}
		return null;
	}
	
	public void setRuntimeProjectName(String runtimeProjectName) {
		this.runtimeProjectName = runtimeProjectName;
	}
	
	public String getRuntimeProjectPluginClass() {
		return runtimePluginClass;
	}

	public void setRuntimeProjectPluginClass(String runtimePluginClass) {
		this.runtimePluginClass = runtimePluginClass;
	}

	public String getJ2EEProjectName() {
		if(j2eeProjectName != null)
			return j2eeProjectName;
		if(pluginProjectPrefix != null)
			return pluginProjectPrefix+".j2ee";
		String ccTechName = getCamelCasedTechnologyName();
		if(ccTechName != null) {
			return "com."+ccTechName+".j2ee";
		}
		return null;
	}
	
	public void setJ2EEProjectName(String projectName) {
		this.j2eeProjectName = projectName;
	}
	
	public String getJ2EEProjectPluginClass() {
		return j2eeProjectPluginClass;
	}
	
	public void setJ2EEProjectPluginClass(String j2eeProjectPluginClass) {
		this.j2eeProjectPluginClass = j2eeProjectPluginClass;
	}
	
	public String getStaticWebProjectName() {
		if(staticWebProjectName != null)
			return staticWebProjectName;
		if(pluginProjectPrefix != null)
			return pluginProjectPrefix+".staticweb";
		String ccTechName = getCamelCasedTechnologyName();
		if(ccTechName != null) {
			return "com."+ccTechName+".staticweb";
		}
		return null;
	}
	
	public void setPluginProjectPrefix(String prefix) {
		this.pluginProjectPrefix = prefix;
	}
	
	public String getPluginProjectPrefix() {
		return this.pluginProjectPrefix;
	}
	
	public void setStaticWebProjectName(String projectName) {
		this.staticWebProjectName = projectName;
	}
	
	public String getStaticWebProjectPluginClass() {
		return staticWebProjectPluginClass;
	}
	
	public void setStaticWebProjectPluginClass(String staticWebProjectPluginClass) {
		this.staticWebProjectPluginClass = staticWebProjectPluginClass;
	}

	public boolean doGenerateApplicationWizard() {
		return generateApplicationWizard;
	}

	public void setGenerateApplicationWizard(boolean generateApplicationWizard) {
		this.generateApplicationWizard = generateApplicationWizard;
	}

	public boolean doGenerateProjectWizard() {
		return generateProjectWizard;
	}

	public void setGenerateProjectWizard(boolean generateProjectWizard) {
		this.generateProjectWizard = generateProjectWizard;
	}

	public String getLargeIconPath() {
		return largeIconPath;
	}

	public String getLargeIconSourcePath() {
		return largeIconSourcePath;
	}

	public void setLargeIconSourcePath(String largeIconSourcePath) {
		this.largeIconSourcePath = largeIconSourcePath;
	}

	public String getSmallIconPath() {
		return smallIconPath;
	}

	public String getSmallIconSourcePath() {
		return smallIconSourcePath;
	}

	public void setSmallIconSourcePath(String smallIconSourcePath) {
		this.smallIconSourcePath = smallIconSourcePath;
	}
	
	public void generateIcons(IProject project) throws CoreException {
		if(smallIconSourcePath != null && !smallIconSourcePath.equals(""))
			smallIconPath = FileCreationUtils.createIconFile(project, smallIconSourcePath, FileCreationUtils.WIZARD_ICON_TYPE);
		if(largeIconSourcePath != null && !largeIconSourcePath.equals(""))
			largeIconPath = FileCreationUtils.createIconFile(project, largeIconSourcePath, FileCreationUtils.WIZARD_ICON_TYPE);
	}
	
	
}
