/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/


package org.eclipse.atf.generator.model;


public class NatureInfo {
	
	private String natureID = null;
	private String natureName = null;
	private String[] builderIDs = null;
	private String packageName = null;
	private String className = null;
	private String artifactsPluginId = null;
	private String artifactsResourcesDir = "resources";
	private String artifactsLibDir = "lib";
	private String containingPluginId = null;
	private String techname = null;
			
	public NatureInfo(String techname) {
		this.techname = techname;
	}
	
	public String[] getBuilderIDs() {
		return builderIDs;
	}
	
	public String getBuilderIDString() {
		if(builderIDs == null)
			return null;
		String builderIDString = "";
		for(int i=0; i<builderIDs.length; i++) { 							
			builderIDString += getFullBuilderID(builderIDs[i]); 		
			if(i != builderIDs.length - 1) builderIDString += ","; 			
		} 	
		return builderIDString;
	}
	
	public void setBuilderIDs(String[] builderIDs) {
		this.builderIDs = builderIDs;
	}
	
	public String getFullBuilderID(String builderID) {
		return containingPluginId + "." + builderID;
	}
	
	public String getFullNatureID() {
		return containingPluginId + "." + getNatureID();
	}
	
	public String getBuilderForId(String id) {
		return Utils.capitalize(id);
	}
	
	public String getNatureName() {
		if(natureName != null)
			return natureName;
		if(techname != null)
			return Utils.capitalize(techname) + " Nature";
		return null;
	}
	
	public void setNatureName(String natureName) {
		this.natureName = natureName;
	}
		
	public String getNatureID() {
		if(natureID != null)
			return natureID;
		if(techname != null)
			return techname+"Nature";
		return null;
	}
	
	public void setNatureID(String natureID) {
		this.natureID = natureID;
	}
	
	public String getClassName() {
		
		if(className != null)
			return className;
		if(techname != null)
			return Utils.capitalize(techname)+"Nature";
		return null;
	}
	
	public void setClassName(String className) {
		this.className = className;
	}
	
	public String getFullClassName() {
		
		if(getPackageName() != null && getClassName() != null) 
			return getPackageName() + "." + getClassName();
		if(getClassName() != null)
			return getClassName();
		return null;
	}
	
	public String getPackageName() {
		
		if(packageName != null)
			return packageName;
		if(techname != null)
			return "com."+techname+".natures";
		return null;
	}
	
	public void setPackageName(String packageName) {
		this.packageName = packageName;
	}

	public String getArtifactsLibDir() {
		return artifactsLibDir;
	}

	public void setArtifactsLibDir(String artifactsLibDir) {
		this.artifactsLibDir = artifactsLibDir;
	}

	public String getArtifactsPluginId() {
		return artifactsPluginId;
	}

	public void setArtifactsPluginId(String artifactsPluginId) {
		this.artifactsPluginId = artifactsPluginId;
	}

	public String getArtifactsResourcesDir() {
		return artifactsResourcesDir;
	}

	public void setArtifactsResourcesDir(String artifactsResourcesDir) {
		this.artifactsResourcesDir = artifactsResourcesDir;
	}

	public String getContainingPluginId() {
		return containingPluginId;
	}

	public void setContainingPluginId(String containingPluginId) {
		this.containingPluginId = containingPluginId;
	}

	public String getTechname() {
		return techname;
	}

	public void setTechname(String techname) {
		this.techname = techname;
	}

			
	
}
