/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/


package org.eclipse.atf.generator.model;


public class PluginClassInfo {

	private NatureInfo natureInfo = null;
	private String pluginID = null;
	private String techName = null;
	
	public PluginClassInfo(String techName, String pluginID, NatureInfo natureInfo) {
		this.natureInfo = natureInfo;
		this.pluginID = pluginID;
		this.techName = techName;
	}

	public NatureInfo getNatureInfo() {
		return natureInfo;
	}

	public void setNatureInfo(NatureInfo natureInfo) {
		this.natureInfo = natureInfo;
	}

	public String getPluginID() {
		return pluginID;
	}

	public void setPluginID(String pluginID) {
		this.pluginID = pluginID;
	}
	
	public String getPackageName() {
		if(techName != null) {
			String name = Utils.uncapitalize(techName.toLowerCase());
			return "com.ibm."+name+".core";
		}
		return null;
	}
	
	public String getClassName() {
		if(techName != null) {
			String name = Utils.capitalize(techName.toLowerCase());
			return name+"CorePlugin";
		}
		return null;
	}
	
	public String getTechnologyName() {
		if(techName != null) {
			return Utils.capitalize(techName);
		}
		return null;
	}
}
