/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/


package org.eclipse.atf.generator.model;


public class ProjectWizardInfo {
	
	private String j2eeClassName = "";
	private String staticWebClassName = "";
	private String packageName = "";
	private String natureToInject = "";
	private String name = "";
	private String category = "";
	private String description = "";
	private int wizardType;
	
	public static final int J2EE_TYPE = 1;
	public static final int NON_J2EE_TYPE = 2;
	public static final int ALL_TYPES = 3;
	
	public String getJ2EEClassName() {
		return j2eeClassName;
	}
	
	public void setJ2EEClassName(String className) {
		this.j2eeClassName = className;
	}
	
	public String getStaticWebClassName() {
		return staticWebClassName;
	}
	
	public void setStaticWebClassName(String className) {
		this.staticWebClassName = className;
	}

	public String getNatureToInject() {
		return natureToInject;
	}
	
	public void setNatureToInject(String natureToInject) {
		this.natureToInject = natureToInject;
	}

	public String getPackageName() {
		return packageName;
	}
	
	public void setPackageName(String packageName) {
		this.packageName = packageName;
	}
	
	public String getDataModelProviderClassName(int forType) {
		if(forType == J2EE_TYPE)
			return j2eeClassName + "DataModelProvider";
		else if(forType == NON_J2EE_TYPE)
			return staticWebClassName + "DataModelProvider";
		return null;
	}
	
	public String getCreationOperationClassName(int forType) {
		if(forType == J2EE_TYPE)
			return null;
		else if(forType == NON_J2EE_TYPE)
			return staticWebClassName + "CreationOperation";
		return null;
	}

	public String getCategory() {
		return category;
	}

	public void setCategory(String category) {
		this.category = category;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public int getWizardType() {
		return wizardType;
	}

	public void setWizardType(int type) {
		this.wizardType = type;
	}
	
	public boolean doCreateJ2EEWizard() {
		if(wizardType == ALL_TYPES || wizardType == J2EE_TYPE)
			return true;
		return false;
	}
	
	public boolean doCreateNonJ2EEWizard() {
		if(wizardType == ALL_TYPES || wizardType == NON_J2EE_TYPE)
			return true;
		return false;
	}

}
