/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.atf.generator.model;

public class RuntimeInfo {

	protected String handlerClassName;
	protected String handlerPackageName;
	protected String runtimeId;
	protected String runtimeName;
	protected String runtimeInstallRoot; //relative path of where the runtime will be installed within projects
	protected String nature;
	
	public RuntimeInfo(){
	}
	
	public RuntimeInfo( String runtimeName ){
		this.runtimeName = runtimeName;
		
		this.handlerClassName = Utils.capitalize(runtimeName) +"RuntimeHandler";
		this.handlerPackageName = "com."+runtimeName+".runtime";
	}
	
	public String getHandlerClassName() {
		return handlerClassName;
	}
	public void setHandlerClassName(String handlerClassName) {
		this.handlerClassName = handlerClassName;
	}
	public String getHandlerPackageName() {
		return handlerPackageName;
	}
	public void setHandlerPackageName(String handlerPackageName) {
		this.handlerPackageName = handlerPackageName;
	}
	public String getNature() {
		return nature;
	}
	public void setNature(String nature) {
		this.nature = nature;
	}
	public String getRuntimeInstallRoot() {
		return runtimeInstallRoot;
	}
	public void setRuntimeInstallRoot(String runtimeInstallRoot) {
		this.runtimeInstallRoot = runtimeInstallRoot;
	}
	public String getRuntimeName() {
		return runtimeName;
	}
	public void setRuntimeName(String runtimeName) {
		this.runtimeName = runtimeName;
	}

	public String getRuntimeId() {
		return runtimeId;
	}

	public void setRuntimeId(String runtimeId) {
		this.runtimeId = runtimeId;
	}
}
