/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/


package org.eclipse.atf.generator.model;

import java.util.ArrayList;

public class SnippetInfo {
	private String name;
	private String displayName;
	private ArrayList variables = new ArrayList();
	private String template;
	
	public SnippetInfo() {
		super();
	}

	public String getDisplayName() {
		return displayName;
	}

	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getTemplate() {
		return template;
	}

	public void setTemplate(String template) {
		this.template = template;
	}
	
	public VariableInfo[] getVariables() {
		VariableInfo[] info = new VariableInfo[variables.size()];
		info = (VariableInfo[])variables.toArray(info);
		return info;
	}
	
	public void addVariable(VariableInfo info) {
		variables.add(info);
	}
	
	public void removeVariable(VariableInfo info) {
		variables.remove(info);
	}
	
	public void removeVariable(String varName) {
		for(int i=0; i<variables.size(); i++) {
			VariableInfo varInfo = (VariableInfo)variables.get(i);
			if(varInfo.getName().equals(varName)) {
				variables.remove(i);
				break;
			}
		}
	}

	public void setVariables(VariableInfo[] vars) {
		if(vars != null) {
			variables.clear();
			for(int i=0; i<vars.length; i++) {
				variables.add(vars[i]);
			}
		}
	}
	
}
