/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/


package org.eclipse.atf.generator.model;

import java.util.ArrayList;

public class VariableGroupInfo {

	private String name;
	private String displayName;
	private ArrayList variableRefs = new ArrayList();
	
	public VariableGroupInfo() {
		super();
	}

	public String getDisplayName() {
		return displayName;
	}

	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public VariableInfo[] getVariableRefs() {
		VariableInfo[] vi = new VariableInfo[variableRefs.size()];
		vi = (VariableInfo[])variableRefs.toArray(vi);
		return vi;
	}
	
	public void addVariableRef(VariableInfo ref) {
		variableRefs.add(ref);
	}
	
	public void removeVariableRef(VariableInfo ref) {
		variableRefs.remove(ref);
	}
	
	public void removeVariableRef(String refname) {
		for(int i=0; i<variableRefs.size(); i++) {
			VariableInfo info = (VariableInfo)variableRefs.get(i);
			if(info.getName().equals(refname)) {
				variableRefs.remove(i);
				break;
			}
		}
	}

	public void setVariableRefs(VariableInfo[] refs) {
		if(refs != null) {
			variableRefs.clear();
			for(int i=0; i<refs.length; i++) {
				variableRefs.add(refs[i]);
			}
		}
	}
	
}
