/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/


package org.eclipse.atf.generator.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;

public class VariableInfo {
	
	public static final String PROJECT_TYPE = "Project";
	public static final String STRING_TYPE = "String";
	public static final String STRING_OPTIONS_TYPE = "StringOptions";
	public static final String BOOLEAN_TYPE = "Boolean";
	public static final String RELATIVE_PATH_TYPE = "RelativePath";
	
	private String name;
	private String displayName;
	private String type;
	private String defaultValue;
	private boolean required;
	private String[] options;
	private String[] filterClasses;
	private HashMap otherAttributes = new HashMap();
	
	public VariableInfo() {
		super();
	}

	public String getDefaultValue() {
		return defaultValue;
	}

	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}

	public String getDisplayName() {
		return displayName;
	}

	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}
	
	public String[] getOptions() {
		return options;
	}
	
	public void setOptions(String[] options) {
		this.options = options;
	}
	
	public void setOptions(String optionString) {
		StringTokenizer strTok = new StringTokenizer(optionString, ",|");
		options = new String[strTok.countTokens()];
		int i=0;
		while(strTok.hasMoreTokens()) {
			options[i] = strTok.nextToken();
			i++;
		}
	}

	public String[] getFilterClasses() {
		return filterClasses;
	}

	public void setFilterClasses(String[] filterClasses) {
		this.filterClasses = filterClasses;
	}

	public boolean isRequired() {
		return required;
	}

	public void setRequired(boolean required) {
		this.required = required;
	}
	
	public void setOtherAttributes( String name, String value ){
		otherAttributes.put( name, value );
	}
	
	public Iterator getOtherAttributeNames(){
		return otherAttributes.keySet().iterator();
	}
	
	public HashMap getOtherAttributes(){
		return otherAttributes;
	}
	
	public void setOtherAttributes( HashMap otherAttributes ){
		this.otherAttributes = otherAttributes;
	}
	
	public String getOtherAttributeValue( String name ){
		if( otherAttributes.containsKey(name) )
			return (String)otherAttributes.get( name );
		else
			return "";
	}
	
	
}
