/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/


package org.eclipse.atf.generator.model;

import java.util.ArrayList;

public class VariableViewPageInfo {
	private String name;
	private String title;
	private String description;
	private ArrayList variableRefs = new ArrayList();
	private ArrayList variableGroups = new ArrayList();
	
	public VariableViewPageInfo() {
		super();
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public VariableGroupInfo[] getVariableGroups() {
		VariableGroupInfo[] info = new VariableGroupInfo[variableGroups.size()];
		info = (VariableGroupInfo[])variableGroups.toArray(info);
		return info;
	}

	public void setVariableGroups(VariableGroupInfo[] groups) {
		if(groups != null) {
			variableGroups.clear();
			for(int i=0; i<groups.length; i++) {
				variableGroups.add(groups[i]);
			}
		}
		
	}
	
	public void addVariableGroup(VariableGroupInfo groupInfo) {
		variableGroups.add(groupInfo);
	}
	
	public void removeVariableGroup(VariableGroupInfo groupInfo) {
		variableGroups.remove(groupInfo);
	}
	
	public void removeVariableGroup(String groupName) {
		for(int i=0; i<variableGroups.size(); i++) {
			VariableGroupInfo groupInfo = (VariableGroupInfo)variableGroups.get(i);
			if(groupInfo.getName().equals(groupName)) {
				variableGroups.remove(i);
				break;
			}
		}
	}
	
	public VariableInfo[] getVariableRefs() {
		VariableInfo[] info = new VariableInfo[variableRefs.size()];
		info = (VariableInfo[])variableRefs.toArray(info);
		return info;
	}
	
	public void addVariableRef(VariableInfo varInfo) {
		variableRefs.add(varInfo);
	}
	
	public void removeVariableRef(VariableInfo varInfo) {
		variableRefs.remove(varInfo);
	}
	
	public void removeVariableRef(String varName) {
		for(int i=0; i<variableRefs.size(); i++) {
			VariableInfo varInfo = (VariableInfo)variableRefs.get(i);
			if(varInfo.getName().equals(varName)) {
				variableRefs.remove(i);
				break;
			}
		}
	}

	public void setVariableRefs(VariableInfo[] refs) {
		if(refs != null) {
			variableRefs.clear();
			for(int i=0; i<refs.length; i++) {
				variableRefs.add(refs[i]);
			}
		}
	}
}
