/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/


package org.eclipse.atf.generator.ui;

import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.TableItem;

public class FileTemplateCellModifier implements ICellModifier {

	private TemplatesTableViewerPanel tableViewerPanel;
	
	public FileTemplateCellModifier(TemplatesTableViewerPanel tableViewerPanel) {
		this.tableViewerPanel = tableViewerPanel;
	}
	
	public boolean canModify(Object element, String property) {
		return true;
	}

	public Object getValue(Object element, String property) {
		
		//Find the index of the column
		int columnIndex = tableViewerPanel.getColumnNames().indexOf(property);

		Object result = null;
		FileTemplate template = (FileTemplate) element;

		switch (columnIndex) {
			case 0 : // NAME
				result = template.getName();
				break;
			case 1 : // LOCATION
				result = template.getLocation();
				break;
			case 2 : // CONDITION 
				result = template.getCondition();				
				break;
			default :
				result = "";
		}
		return result;	
	}

	public void modify(Object element, String property, Object value) {
		
		//Find the index of the column 
		int columnIndex	= tableViewerPanel.getColumnNames().indexOf(property);
			
		TableItem item = (TableItem) element;
		FileTemplate template = (FileTemplate) item.getData();
		String valueString;

		switch (columnIndex) {
			case 0 : // NAME
				template.setName((String)value);
			    break;
			case 1 : // LOCATION
				template.setLocation((String)value);
				break;
			case 2 : // CONDITION
				template.setCondition((String)value);
				break;
			default :
		}
		tableViewerPanel.getTemplateList().templateChanged(template);

	}

}
