/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/


package org.eclipse.atf.generator.ui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class FileTemplateList {

	protected Set changeListeners = new HashSet();
	protected ArrayList templates = new ArrayList();
	
	public FileTemplateList() {
		super();
	}
	
	public ArrayList getTemplates() {
		return templates;
	}
	
	public void addTemplate() {
		FileTemplate template = new FileTemplate();
		templates.add(templates.size(), template);
		Iterator iterator = changeListeners.iterator();
		while (iterator.hasNext())
			((ITemplateListViewer) iterator.next()).addTemplate(template);
	}

	/**
	 * @param template
	 */
	public void removeTemplate(FileTemplate template) {
		templates.remove(template);
		Iterator iterator = changeListeners.iterator();
		while (iterator.hasNext())
			((ITemplateListViewer) iterator.next()).removeTemplate(template);
	}

	/**
	 * @param template
	 */
	public void templateChanged(FileTemplate template) {
		Iterator iterator = changeListeners.iterator();
		while (iterator.hasNext())
			((ITemplateListViewer) iterator.next()).updateTemplate(template);
	}

	/**
	 * @param viewer
	 */
	public void removeChangeListener(ITemplateListViewer viewer) {
		changeListeners.remove(viewer);
	}

	/**
	 * @param viewer
	 */
	public void addChangeListener(ITemplateListViewer viewer) {
		changeListeners.add(viewer);
	}
}
