/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/


package org.eclipse.atf.generator.ui;

public interface ISnippetListViewer {

	/**
	 * Update the view to reflect the fact that a snippet was added 
	 * to the snippet list
	 * 
	 * @param snippet
	 */
	public void addSnippet(Snippet snippet);
	
	/**
	 * Update the view to reflect the fact that a snippet was removed 
	 * from the snippet list
	 * 
	 * @param snippet
	 */
	public void removeSnippet(Snippet snippet);
	
	/**
	 * Update the view to reflect the fact that one of the snippets
	 * was modified 
	 * 
	 * @param snippet
	 */
	public void updateSnippet(Snippet snippet);
}
