/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/


package org.eclipse.atf.generator.ui;

public interface ITemplateListViewer {

	/**
	 * Update the view to reflect the fact that a template was added 
	 * to the template list
	 * 
	 * @param template
	 */
	public void addTemplate(FileTemplate template);
	
	/**
	 * Update the view to reflect the fact that a template was removed 
	 * from the template list
	 * 
	 * @param template
	 */
	public void removeTemplate(FileTemplate template);
	
	/**
	 * Update the view to reflect the fact that one of the templates
	 * was modified 
	 * 
	 * @param template
	 */
	public void updateTemplate(FileTemplate template);
}
