/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/


package org.eclipse.atf.generator.ui;


	public interface IVariableListViewer {

		/**
		 * Update the view to reflect the fact that a variable was added 
		 * to the variable list
		 * 
		 * @param var
		 */
		public void addVariable(Variable var);
		
		/**
		 * Update the view to reflect the fact that a variable was removed 
		 * from the variable list
		 * 
		 * @param var
		 */
		public void removeVariable(Variable var);
		
		/**
		 * Update the view to reflect the fact that one of the variables
		 * was modified 
		 * 
		 * @param var
		 */
		public void updateVariable(Variable var);
}
