/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/


package org.eclipse.atf.generator.ui;

public interface IViewPageListViewer {

	/**
	 * Update the view to reflect the fact that a page was added 
	 * to the page list
	 * 
	 * @param page
	 */
	public void addPage(ViewPage page);
	
	/**
	 * Update the view to reflect the fact that a page was removed 
	 * from the page list
	 * 
	 * @param page
	 */
	public void removePage(ViewPage page);
	
	/**
	 * Update the view to reflect the fact that one of the pages
	 * was modified 
	 * 
	 * @param page
	 */
	public void updatePage(ViewPage page);
}
