/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/


package org.eclipse.atf.generator.ui;

import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.TableItem;

public class SnippetCellModifier implements ICellModifier {

	private SnippetsTableViewerPanel snippetsTableViewerPanel;
	
	public SnippetCellModifier(SnippetsTableViewerPanel viewerPanel) {
		this.snippetsTableViewerPanel = viewerPanel;
	}
	
	public boolean canModify(Object element, String property) {
		return true;
	}

	public Object getValue(Object element, String property) {
		//Find the index of the column
		int columnIndex = snippetsTableViewerPanel.getColumnNames().indexOf(property);

		Object result = null;
		Snippet snippet = (Snippet) element;

		switch (columnIndex) {
			case 0 : // NAME
				result = snippet.getName();
				break;
			case 1 : // DISPLAY NAME
				result = snippet.getDisplayName();
				break;
			default :
				result = "";
		}
		return result;	
	}

	public void modify(Object element, String property, Object value) {
		
		//Find the index of the column 
		int columnIndex	= snippetsTableViewerPanel.getColumnNames().indexOf(property);
			
		TableItem item = (TableItem) element;
		Snippet snippet = (Snippet) item.getData();
		String valueString;

		switch (columnIndex) {
			case 0 : // NAME
				snippet.setName((String)value);
			    break;
			case 1 : // DISPLAY NAME
				snippet.setDisplayName((String)value);
				break;
			default :
		}
		snippetsTableViewerPanel.getSnippetList().snippetChanged(snippet);

	}

}
