/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/


package org.eclipse.atf.generator.ui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SnippetList {

	protected Set changeListeners = new HashSet();
	protected ArrayList snippets = new ArrayList();
	
	public SnippetList() {
		super();
	}
	
	public ArrayList getSnippets() {
		return snippets;
	}
	
	public Snippet getSnippet(String name) {
		for(int i=0; i<snippets.size(); i++) {
			Snippet snippet = (Snippet)snippets.get(i);
			if(snippet.getName().equals(name))
				return snippet;
		}
		return null;
	}
	
	public void addSnippet() {
		Snippet snippet = new Snippet();
		snippets.add(snippets.size(), snippet);
		Iterator iterator = changeListeners.iterator();
		while (iterator.hasNext())
			((ISnippetListViewer) iterator.next()).addSnippet(snippet);
	}
	
	public void addSnippet(Snippet snippet) {
		snippets.add(snippets.size(), snippet);
		Iterator iterator = changeListeners.iterator();
		while (iterator.hasNext())
			((ISnippetListViewer) iterator.next()).addSnippet(snippet);
	}

	public void removeSnippet(Snippet snippet) {
		snippets.remove(snippet);
		Iterator iterator = changeListeners.iterator();
		while (iterator.hasNext())
			((ISnippetListViewer) iterator.next()).removeSnippet(snippet);
	}

	public void snippetChanged(Snippet snippet) {
		Iterator iterator = changeListeners.iterator();
		while (iterator.hasNext())
			((ISnippetListViewer) iterator.next()).updateSnippet(snippet);
	}

	public void removeChangeListener(ISnippetListViewer viewer) {
		changeListeners.remove(viewer);
	}

	public void addChangeListener(ISnippetListViewer viewer) {
		changeListeners.add(viewer);
	}
}
