/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/


package org.eclipse.atf.generator.ui;

import java.util.HashMap;
import java.util.Iterator;


public class Variable {

	private String name = "NEWVAR";
	private String displayName = "";
	private String type = "String";
	private String defaultValue = "";
	private String options = "";
	private boolean required = false;
	private boolean isEditable = true;
	private HashMap otherAttributes = new HashMap();
	
	public Variable() {
		super();
	}
	
	public Variable(String name) {
		super();
		this.name = name;
	}

	public String getDefaultValue() {
		return defaultValue;
	}

	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}

	public String getDisplayName() {
		return displayName;
	}

	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public boolean isEditable() {
		return isEditable;
	}

	public void setEditable(boolean isEditable) {
		this.isEditable = isEditable;
	}
	
	public String getOptions() {
		return options;
	}
	
	public void setOptions(String options) {
		this.options = options;
	}

	public boolean isRequired() {
		return required;
	}

	public void setRequired(boolean required) {
		this.required = required;
	}
		
	public void setOtherAttributes( String name, String value ){
		otherAttributes.put( name, value );
	}
	
	public Iterator getOtherAttributeNames(){
		return otherAttributes.keySet().iterator();
	}
	
	public HashMap getOtherAttributes(){
		return otherAttributes;
	}
	
	public String getOtherAttributeValue( String name ){
		if( otherAttributes.containsKey(name) )
			return (String)otherAttributes.get( name );
		else
			return "";
	}
}
