/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/


package org.eclipse.atf.generator.ui;

import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.TableItem;


public class VariableCellModifier implements ICellModifier {

	private VariablesTableViewerPanel variablesTableViewerPanel;
	
	public VariableCellModifier(VariablesTableViewerPanel tableViewerPanel) {
		this.variablesTableViewerPanel = tableViewerPanel;
	}
	
	public boolean canModify(Object element, String property) {
		Variable var = (Variable)element;
		if(var.isEditable()) {
			if(property.equals(VariablesTableViewerPanel.OPTIONS_COL) && !var.getType().equals("StringOptions"))
				return false;
			return true;
		} else if(property.equals(VariablesTableViewerPanel.DEFAULT_VALUE_COL) && var.getName().equals("appRoot")) {
			return true;
		}
		return false;
		
	}

	public Object getValue(Object element, String property) {
		
		//Find the index of the column
		int columnIndex = variablesTableViewerPanel.getColumnNames().indexOf(property);

		Object result = null;
		Variable var = (Variable) element;

		switch (columnIndex) {
			case 0 : // NAME
				result = var.getName();
				break;
			case 1 : // DISPLAY NAME
				result = var.getDisplayName();
				break;
			case 2 : // TYPE 
				String stringValue = var.getType();
				String[] choices = variablesTableViewerPanel.getChoices(property);
				int i = choices.length - 1;
				while (!stringValue.equals(choices[i]) && i > 0)
					--i;
				result = new Integer(i);					
				break;
			case 3 : // DEFAULT VALUE
				result = var.getDefaultValue();;
				break;
			case 4 : // OPTIONS
				result = var.getOptions();
				break;
			case 5 : // REQUIRED
				stringValue = var.isRequired()+"";
				choices = variablesTableViewerPanel.getChoices(property);
				i = choices.length - 1;
				while (!stringValue.equals(choices[i]) && i > 0)
					--i;
				result = new Integer(i);
				break;
			default :
				result = "";
		}
		return result;	
	}

	public void modify(Object element, String property, Object value) {
		
		//Find the index of the column 
		int columnIndex	= variablesTableViewerPanel.getColumnNames().indexOf(property);
			
		TableItem item = (TableItem) element;
		Variable var = (Variable) item.getData();
		String valueString;

		switch (columnIndex) {
			case 0 : // NAME
				var.setName((String)value);
			    break;
			case 1 : // DESCRIPTION_COLUMN 
				var.setDisplayName((String)value);
				break;
			case 2 : // TYPE
				valueString = variablesTableViewerPanel.getChoices(property)[((Integer) value).intValue()].trim();
				if (!var.getType().equals(valueString)) {
					var.setType(valueString);
					var.setOptions("");
					//if(!valueString.equals("StringOptions")) {
					//	var.setOptions("Not Applicable");
					//} else {
					//	var.setOptions("");
					//}
				}
				break;
			case 3 : // DEFAULT VALUE
				var.setDefaultValue((String)value);
				break;
			case 4 : // OPTIONS
				var.setOptions((String)value);
				break;
			case 5 : //REQUIRED
				valueString = variablesTableViewerPanel.getChoices(property)[((Integer)value).intValue()].trim();
				if (!(var.isRequired()+"").equals(valueString)) {
					var.setRequired(new Boolean(valueString).booleanValue());
				}
				break;
			default :
		}
		variablesTableViewerPanel.getVariableList().variableChanged(var);

	}
	
	

}
