/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/


package org.eclipse.atf.generator.ui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;


public class VariableList {

	private String[] typeOptions;
	protected Set changeListeners = new HashSet();
	protected ArrayList variables = new ArrayList();
	
	public VariableList() {
		super();
	}
	
	public String[] getTypeOptions() {
		if(typeOptions == null) {
			typeOptions = new VariableTypeExtensionReader().getAvailableFactoryTypes();
		}
		return typeOptions;
	}
	
	public ArrayList getVariables() {
		return variables;
	}
	
	public Variable getVariable(String name) {
		for(int i=0; i<variables.size(); i++) {
			Variable var = (Variable)variables.get(i);
			if(var.getName().equals(name))
				return var;
		}
		return null;
	}
	
	public void addVariable() {
		Variable var = new Variable();
		variables.add(variables.size(), var);
		Iterator iterator = changeListeners.iterator();
		while (iterator.hasNext())
			((IVariableListViewer) iterator.next()).addVariable(var);
	}
	
	public void addVariable(Variable var) {
		variables.add(variables.size(), var);
		Iterator iterator = changeListeners.iterator();
		while (iterator.hasNext())
			((IVariableListViewer) iterator.next()).addVariable(var);
	}

	/**
	 * @param var
	 */
	public void removeVariable(Variable var) {
		if(!var.isEditable())
			return;
		variables.remove(var);
		Iterator iterator = changeListeners.iterator();
		while (iterator.hasNext())
			((IVariableListViewer) iterator.next()).removeVariable(var);
	}
	
	public void removeAll() {
		Variable[] vars = new Variable[variables.size()];
		vars = (Variable[])variables.toArray(vars);
		for(int i=0; i<vars.length; i++) {
			if(!vars[i].isEditable())
				continue;
			variables.remove(vars[i]);
			Iterator iterator = changeListeners.iterator();
			while (iterator.hasNext())
				((IVariableListViewer) iterator.next()).removeVariable(vars[i]);
		}
	}

	/**
	 * @param var
	 */
	public void variableChanged(Variable var) {
		Iterator iterator = changeListeners.iterator();
		while (iterator.hasNext())
			((IVariableListViewer) iterator.next()).updateVariable(var);
	}

	/**
	 * @param viewer
	 */
	public void removeChangeListener(IVariableListViewer viewer) {
		changeListeners.remove(viewer);
	}

	/**
	 * @param viewer
	 */
	public void addChangeListener(IVariableListViewer viewer) {
		changeListeners.add(viewer);
	}
}
