/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/


package org.eclipse.atf.generator.ui;

import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.TableItem;

public class VariableRefCellModifier implements ICellModifier {

	VariableRefsTableViewerPanel tableViewerPanel;
	
	public VariableRefCellModifier(VariableRefsTableViewerPanel tableViewerPanel) {
		this.tableViewerPanel = tableViewerPanel;
	}
	
	public boolean canModify(Object element, String property) {
		
		Variable var = (Variable)element;
		if(!var.isEditable())
			return false;
		if(property.equals(VariableRefsTableViewerPanel.NAME_COL))
			return true;
		return false;
	}

	public Object getValue(Object element, String property) {
		//Find the index of the column
		int columnIndex = tableViewerPanel.getColumnNames().indexOf(property);

		Object result = null;
		Variable var = (Variable) element;

		switch (columnIndex) {
			case 0 : // NAME
				String stringValue = var.getName();
				String[] choices = tableViewerPanel.getChoices(property);
				int i = choices.length - 1;
				while(!stringValue.equals(choices[i]) && i > 0)
					--i;
				result = new Integer(i);
				break;
			case 1 : // DISPLAY NAME
				result = var.getDisplayName();
				break;
			case 2 : // TYPE 
				result = var.getType();				
				break;
			default :
				result = "";
		}
		return result;	
	}

	public void modify(Object element, String property, Object value) {
		
		//Find the index of the column 
		int columnIndex	= tableViewerPanel.getColumnNames().indexOf(property);
			
		TableItem item = (TableItem) element;
		Variable var = (Variable) item.getData();
		String valueString;

		switch (columnIndex) {
			case 0 : // NAME
				valueString = tableViewerPanel.getChoices(property)[((Integer) value).intValue()].trim();
				if (!var.getName().equals(valueString)) {
					var.setName(valueString);
					syncVariable(var);
					
				}
			    break;
			case 1 : // DESCRIPTION_COLUMN 
				var.setDisplayName((String)value);
				break;
			case 2 : // TYPE
				var.setType((String)value);
				break;
			default :
		}
		tableViewerPanel.getVariableList().variableChanged(var);

	}
	
	protected void syncVariable(Variable var) {
		String name = var.getName();
		Variable[] vars = tableViewerPanel.getAvailableVariables();
		for(int i=0; i<vars.length; i++) {
			if(vars[i].getName().equals(name)) {
				var.setDisplayName(vars[i].getDisplayName());
				var.setDefaultValue(vars[i].getDefaultValue());
				var.setType(vars[i].getType());
			}
		}
			
	}

}
