/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/


package org.eclipse.atf.generator.ui;


public class VariableRefsList extends VariableList {

	protected String[] nameOptions;
	protected Variable[] availableVariables;
	protected String[] availableVariableNames;
		
	
		
	public VariableRefsList(Variable[] availableVariables) {
		setAvailableVariables(availableVariables);
	}
	
	public String[] getNameOptions() {
		
		return availableVariableNames;
	}
	
	public void setAvailableVariables(Variable[] availableVariables) {
		this.availableVariables = availableVariables;
		if(availableVariables == null) {
			availableVariableNames = null;
		} else {
			availableVariableNames = new String[availableVariables.length];
			for(int i=0; i<availableVariableNames.length; i++) {
				availableVariableNames[i] = availableVariables[i].getName();
			}
		}
	}
}
