/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/


package org.eclipse.atf.generator.ui;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;


public class VariableRefsTableViewerPanel extends VariablesTableViewerPanel {
	
	protected Variable[] availableVariables;
	protected ComboBoxCellEditor nameEditor;
	protected TextCellEditor displayNameEditor;
	protected TextCellEditor typeEditor;
	
	public VariableRefsTableViewerPanel(Composite parent, int style, Variable[] availableVariables) {
		this(parent, style);
		this.availableVariables = availableVariables;
		variableList = new VariableRefsList(availableVariables);
		
	}
	
	public VariableRefsTableViewerPanel(Composite parent, int style) {
		super(parent, style);
				
	}
	
	protected void initialize() {
		variableList = new VariableRefsList(new Variable[0]);
		columnNames = new String[] {NAME_COL, DISPLAY_NAME_COL, TYPE_COL};
	}
	
	protected void createTable() {
		
		int style = SWT.SINGLE | SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL | 
				SWT.FULL_SELECTION | SWT.HIDE_SELECTION;
		
		table = new Table(this, style);
						
		GridData gridData = new GridData(GridData.FILL_BOTH);
		gridData.grabExcessVerticalSpace = true;
		table.setLayoutData(gridData);		
				
		table.setLinesVisible(true);
		table.setHeaderVisible(true);
		
		// 1st column 
		TableColumn column = new TableColumn(table, SWT.LEFT, 0);		
		column.setText("Name");
		column.setWidth(100);
		
		// 2nd column 
		column = new TableColumn(table, SWT.LEFT, 1);
		column.setText("Display Name");
		column.setWidth(150);
						
		// 3rd column 
		column = new TableColumn(table, SWT.LEFT, 2);
		column.setText("Type");
		column.setWidth(100);
				
				
	}
	
	protected void createTableViewer() {
		
		tableViewer = new TableViewer(table); 
		tableViewer.setUseHashlookup(true);
		
		tableViewer.setColumnProperties(columnNames);

		// Create the cell editors
		CellEditor[] editors = new CellEditor[columnNames.length];

		// Column 1 : Name (text)
		nameEditor = new ComboBoxCellEditor(table, variableList == null ? new String[0] : ((VariableRefsList)variableList).getNameOptions(), SWT.READ_ONLY);
		editors[0] = nameEditor;
				
		// Column 2 : Display Name (text)
		displayNameEditor = new TextCellEditor(table);
		((Text) displayNameEditor.getControl()).setTextLimit(150);
		editors[1] = displayNameEditor;

		// Column 3 : Type
		typeEditor = new TextCellEditor(table);
		((Text) typeEditor.getControl()).setTextLimit(150);
		editors[2] = typeEditor;

		// Assign the cell editors to the viewer 
		tableViewer.setCellEditors(editors);
		// Set the cell modifier for the viewer
		tableViewer.setCellModifier(new VariableRefCellModifier(this));
		
	}
	
	public String[] getChoices(String property) {
		if (NAME_COL.equals(property)) {
			return ((VariableRefsList)variableList).getNameOptions();  
		}
		else
			return new String[]{};
	}
	
	public void setAvailableVariables(Variable[] availableVariables) {
		this.availableVariables = availableVariables;
		((VariableRefsList)variableList).setAvailableVariables(availableVariables);
		nameEditor.setItems(((VariableRefsList)variableList).getNameOptions());
		
	}
	
	public Variable[] getAvailableVariables() {
		return this.availableVariables;
	}
}
