/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/


package org.eclipse.atf.generator.ui;

import java.util.ArrayList;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class VariableTypeExtensionReader {

	public static final String PLUGIN_ID = "org.eclipse.atf.templates";
	public static final String EXTENSION_POINT_ID = "variableFactory";
	public static final String TYPE_ATTRIBUTE = "type";
	
	public VariableTypeExtensionReader() {
		super();
	}
	
	protected IExtensionPoint getExtensionPoint(){
		IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
		IExtensionPoint point = extensionRegistry.getExtensionPoint(PLUGIN_ID, EXTENSION_POINT_ID);
		
		return point;
	}
	
	public String[] getAvailableFactoryTypes() {
		
		IExtensionPoint point =  getExtensionPoint();
		
		if( point == null ){
			System.err.println( "ERROR: No contributions to the org.eclipse.atf.templates.variableFactory extension loaded!");
			return null;
		}
		
		//contributions made to the extension point
		IConfigurationElement [] configElements = point.getConfigurationElements();
		ArrayList list = new ArrayList();
		for( int i=0; i<configElements.length; i++ ){
			String type = configElements[i].getAttribute(TYPE_ATTRIBUTE);
			if(!list.contains(type))
				list.add(type);
		}
		String[] types = new String[list.size()];
		types = (String[]) list.toArray(types);
		return types;
	}
}
