/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/


package org.eclipse.atf.generator.ui;

import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.TableItem;

public class ViewPageCellModifier implements ICellModifier {

	private PageTableViewerPanel pageTableViewerPanel;
	
	public ViewPageCellModifier(PageTableViewerPanel pageTableViewerPanel) {
		this.pageTableViewerPanel = pageTableViewerPanel;
	}
	
	public boolean canModify(Object element, String property) {
		
		return true;
	}

	public Object getValue(Object element, String property) {
		//Find the index of the column
		int columnIndex = pageTableViewerPanel.getColumnNames().indexOf(property);

		Object result = null;
		ViewPage page = (ViewPage) element;

		switch (columnIndex) {
			case 0 : // NAME
				result = page.getName();
				break;
			case 1 : // TITLE
				result = page.getTitle();
				break;
			case 2 : // DESCRIPTION
				result = page.getDescription();
				break;
			default :
				result = "";
		}
		return result;	
	}

	public void modify(Object element, String property, Object value) {

		//Find the index of the column 
		int columnIndex	= pageTableViewerPanel.getColumnNames().indexOf(property);
			
		TableItem item = (TableItem) element;
		ViewPage page = (ViewPage) item.getData();
		
		switch (columnIndex) {
			case 0 : // NAME
				page.setName((String)value);
			    break;
			case 1 : // TITLE
				page.setTitle((String)value);
				break;
			case 2 : // DESCRIPTION
				page.setDescription((String)value);
				break;
			default :
		}
		pageTableViewerPanel.getPageList().pageChanged(page);

	}

}
