/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/


package org.eclipse.atf.generator.ui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ViewPageList {

	private Set changeListeners = new HashSet();
	private ArrayList pages = new ArrayList();
	
	public ViewPageList() {
		super();
		initData();
	}
	
	protected void initData() {
		ViewPage page = new ViewPage();
		page.setName("Page1");
		page.setTitle("Name and Location");
		page.setDescription("Specify name and location.");
		page.setRequired(true);
		pages.add(page);
	}
	
	public ArrayList getPages() {
		return pages;
	}
	
	public void addPage() {
		ViewPage page = new ViewPage();
		pages.add(pages.size(), page);
		Iterator iterator = changeListeners.iterator();
		while (iterator.hasNext())
			((IViewPageListViewer) iterator.next()).addPage(page);
	}

	/**
	 * @param page
	 */
	public void removePage(ViewPage page) {
		if(pages.size() == 1)
			return;
		pages.remove(page);
		Iterator iterator = changeListeners.iterator();
		while (iterator.hasNext())
			((IViewPageListViewer) iterator.next()).removePage(page);
	}

	/**
	 * @param page
	 */
	public void pageChanged(ViewPage page) {
		Iterator iterator = changeListeners.iterator();
		while (iterator.hasNext())
			((IViewPageListViewer) iterator.next()).updatePage(page);
	}

	/**
	 * @param viewer
	 */
	public void removeChangeListener(IViewPageListViewer viewer) {
		changeListeners.remove(viewer);
	}

	/**
	 * @param viewer
	 */
	public void addChangeListener(IViewPageListViewer viewer) {
		changeListeners.add(viewer);
	}
	
	
}
