/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/


package org.eclipse.atf.generator.ui.wizards;

import org.eclipse.atf.generator.model.MrCleanToolingInfo;
import org.eclipse.atf.generator.model.ProjectWizardInfo;
import org.eclipse.atf.generator.model.Utils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;


public class ProjectWizardWizardPage extends WizardPage implements SelectionListener, ModifyListener{

	//private Button projectWizardCheckBox;
	private Text nameText;
	private Text descriptionText;
	private Text j2eeClassText;
	//private Text standardWebClassText;
	private Button j2eeCheckBox;
	//private Button standardWebCheckBox;
		
	private String wizardName;
	private String wizardDescription;
	private String natureToInject;
	private String wizardPackage;
	private String j2eeWizardClass;
	private String standardWebWizardClass;
	
	private int type;
		
	private MrCleanToolingInfo dataModel; 
	private boolean generateProjectWizard = true;
	private boolean controlsInitted = false;
	private boolean dataInitted = false;
	
	public static final String J2EE_SELECTION = "J2EE";
	
	public ProjectWizardWizardPage(MrCleanToolingInfo dataModel) {
		super("New Project Wizard");
		setTitle("Project Wizard generation"); //$NON-NLS-1$
	    setDescription("Specify information to create a project wizard"); //$NON-NLS-1$
	    ProjectWizardInfo info = dataModel.getProjectWizardInfo();
	    if(info == null) {
	    	info = new ProjectWizardInfo();
	    	dataModel.setProjectWizardInfo(info);
	    }
	    this.dataModel = dataModel;
	    		
	}
	
	public void createControl(Composite parent) {
		initializeDialogUnits(parent);
		Composite composite = new Composite(parent, SWT.NONE);
		composite.setFont(parent.getFont());
		composite.setLayout(new GridLayout());
		composite.setLayoutData(new GridData(GridData.FILL_BOTH));
				
		createProjectWizardControls(composite);
				
		setControl(composite);
		Dialog.applyDialogFont(composite);

	}
	
		
	private void createProjectWizardControls(Composite parent) {
		
		Composite composite = new Composite(parent, SWT.NULL);
		composite.setFont(parent.getFont());
		GridLayout layout = new GridLayout();
		layout.numColumns = 2;
		composite.setLayout(layout);
		composite.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		Group serverGroup = new Group(parent, SWT.NULL);
		serverGroup.setText("Wizard Types");
		layout = new GridLayout();
		layout.numColumns = 2;
		serverGroup.setLayout(layout);
		serverGroup.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		//projectWizardCheckBox = new Button(composite, SWT.CHECK);
		//projectWizardCheckBox.setText("Generate project wizard");
		//projectWizardCheckBox.addSelectionListener(this);
		//GridData gData = new GridData(GridData.FILL_HORIZONTAL);
		//gData.horizontalSpan = 2;
		//projectWizardCheckBox.setLayoutData(gData);
		
		Label nameLabel = new Label(composite, SWT.NONE);
		nameLabel.setText("Name:");
		nameText = new Text(composite, SWT.BORDER);
		nameText.addModifyListener(this);
		GridData gData = new GridData(GridData.FILL_HORIZONTAL);
		nameText.setLayoutData(gData);
		
		Label descriptionLabel = new Label(composite, SWT.NONE);
		descriptionLabel.setText("Description:");
		descriptionText = new Text(composite, SWT.BORDER);
		descriptionText.addModifyListener(this);
		descriptionText.setLayoutData(gData);
		
		j2eeCheckBox = new Button(serverGroup, SWT.CHECK);
		j2eeCheckBox.setText("J2EE");
		j2eeCheckBox.addSelectionListener(this);
		gData = new GridData(GridData.FILL_HORIZONTAL);
		gData.horizontalSpan = 2;
		j2eeCheckBox.setLayoutData(gData);
		j2eeCheckBox.setEnabled(false);
				
		Label j2eeClassLabel = new Label(serverGroup, SWT.NONE);
		j2eeClassLabel.setText("Class:");
		j2eeClassText = new Text(serverGroup, SWT.BORDER);
		j2eeClassText.addModifyListener(this);
		j2eeClassText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		/*standardWebCheckBox = new Button(serverGroup, SWT.CHECK);
		standardWebCheckBox.setText("Standard Web");
		standardWebCheckBox.addSelectionListener(this);
		standardWebCheckBox.setLayoutData(gData);
				
		Label standardWebClassLabel = new Label(serverGroup, SWT.NONE);
		standardWebClassLabel.setText("Class:");
		standardWebClassText = new Text(serverGroup, SWT.BORDER);
		standardWebClassText.addModifyListener(this);
		standardWebClassText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		*/
		
		initializeControlContents();
	}
	
	public void initializeControlContents() {
		if(!controlsInitted) {
			updateControlContents();
			j2eeCheckBox.setSelection(true);
			//standardWebCheckBox.setSelection(true);
			//projectWizardCheckBox.setSelection(generateProjectWizard);
			controlsInitted = true;
		}
	}
	
	protected void updateControlContents() {
		initializeWizardData();
		if(wizardName != null)
			nameText.setText(wizardName);
		if(wizardDescription != null)
			descriptionText.setText(wizardDescription);
		if(j2eeWizardClass != null)	
			j2eeClassText.setText(j2eeWizardClass);
		//if(standardWizardClass != null)	
			//standardWebClassText.setText(standardWebWizardClass);
		
		updateDataModel();
	}
	
	private void initializeWizardData() {
		String uiProject = dataModel.getUiProjectName();
		if(uiProject != null && !uiProject.equals("")) {
			//if(wizardPackage == null)
				wizardPackage = uiProject + ".wizard";
		}
			
		String techName = dataModel.getCamelCasedTechnologyName();
		if(techName != null && !techName.equals("")) {
			//if(wizardName == null)
				wizardName = Utils.capitalize(techName + " Project");
			//if(wizardDescription == null)
				wizardDescription = "Creates new " + Utils.capitalize(techName) + " project";
			//if(j2eeWizardClass == null)
				j2eeWizardClass = Utils.capitalize(techName + "J2EEProjectWizard");
			//if(standardWebWizardClass == null)
			//	standardWebWizardClass = Utils.capitalize(techName + "StaticWebProjectWizard");
		}
			
		String natureId = dataModel.getNatureInfo().getNatureID();
		if(natureId != null) {
			String coreProject = dataModel.getCoreProjectName();
			if(coreProject != null)
				natureToInject = coreProject + "." + natureId;
		}
		
	}
	
	public void widgetSelected(SelectionEvent e) {
		if(e.widget.equals(j2eeCheckBox)) {
			j2eeClassText.setEnabled(j2eeCheckBox.getSelection());
		} /*else if(e.widget.equals(standardWebCheckBox)) {
			standardWebClassText.setEnabled(standardWebCheckBox.getSelection());
		} */
		
		setPageComplete(validatePage());
			
	}
	
	public void widgetDefaultSelected(SelectionEvent e) { }

	public void modifyText(ModifyEvent e) {
		Widget w = e.widget;
		if(w.equals(nameText))
			wizardName = nameText.getText();
		else if(w.equals(j2eeClassText))
			j2eeWizardClass = j2eeClassText.getText();
		//else if(w.equals(standardWebClassText))
		//	standardWebWizardClass = standardWebClassText.getText();
		else if(w.equals(descriptionText))
			wizardDescription = descriptionText.getText();
		else if(w.equals(j2eeCheckBox))
			type = getWizardType();
		//else if(w.equals(standardWebCheckBox)) 
		//	type = getWizardType();
					
		setPageComplete(validatePage());
	}
	
	
	protected int getWizardType() {
		/*if(j2eeCheckBox.getSelection() && standardWebCheckBox.getSelection())
			return ProjectWizardInfo.ALL_TYPES;
		else if(j2eeCheckBox.getSelection() && !standardWebCheckBox.getSelection())
			return ProjectWizardInfo.J2EE_TYPE;
		else if(!j2eeCheckBox.getSelection() && standardWebCheckBox.getSelection())
			return ProjectWizardInfo.NON_J2EE_TYPE;
		else
			return -1;
		*/
		return ProjectWizardInfo.J2EE_TYPE;
	}

	public void setVisible(boolean visible) {
		if(visible)
			updateControlContents();
		super.setVisible(visible);
	}
	
	public void setPageComplete(boolean complete) {
        super.setPageComplete(complete);
        if(complete) {
        	updateDataModel();
		}
    }
	
	protected boolean validatePage() {
		if(!validateName()) {
			setErrorMessage("Valid name must be specified.");
			return false;
		} else if(!validateDescription()) {
			setErrorMessage("Valid description must be specified.");
			return false;
		} else if(!validateJ2EEWizardType()) {
			setErrorMessage("Invalid input for J2EE wizard type.");
			return false;
		} else if(!validateStandardWizardType()) {
			setErrorMessage("Invalid input for standard web wizard type.");
			return false;
		}
		setErrorMessage(null);
		return true;
	}
	
	protected boolean validateName() {
		if(wizardName == null || wizardName.equals(""))
			return false;
		return true;
	}
	
	protected boolean validateDescription() {
		if(wizardDescription == null || wizardDescription.equals(""))
			return false;
		return true;
	}
	
	protected boolean validateJ2EEWizardType() {
		if(getWizardType() == ProjectWizardInfo.J2EE_TYPE ||
				getWizardType() == ProjectWizardInfo.ALL_TYPES) {
			if(j2eeWizardClass == null || j2eeWizardClass.equals(""))
				return false;
		}
		return true;
	}
	
	protected boolean validateStandardWizardType() {
		if(getWizardType() == ProjectWizardInfo.NON_J2EE_TYPE ||
				getWizardType() == ProjectWizardInfo.ALL_TYPES) {
			if(standardWebWizardClass == null || standardWebWizardClass.equals(""))
				return false;
		}
		return true;
	}
	
	public void updateDataModel() {
		
		initializeWizardData();
		
		ProjectWizardInfo info = dataModel.getProjectWizardInfo();
		info.setJ2EEClassName(j2eeWizardClass);
		info.setStaticWebClassName(standardWebWizardClass);
		info.setDescription(wizardDescription);
		info.setName(wizardName);
		info.setNatureToInject(natureToInject);
		info.setPackageName(wizardPackage);
		info.setWizardType(getWizardType());
						
		dataModel.setGenerateProjectWizard(generateProjectWizard);
		
	}
	
	

}
