/*******************************************************************************
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/


package org.eclipse.atf.generator.ui.wizards;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.atf.generator.GeneratorPlugin;
import org.eclipse.core.runtime.Platform;


/**
 * Convenience class for getting strings from a resource bundle.
 */
public class WizardMessages
{
  private static final ResourceBundle RESOURCE_BUNDLE = Platform.getResourceBundle(GeneratorPlugin.getDefault().getBundle());

  private WizardMessages()
  {
  }

  public static String getString(String key)
  {
    try
    {
      return RESOURCE_BUNDLE.getString(key);
    }
    catch (MissingResourceException e)
    {
      return '!' + key + '!';
    }
  }

  /**
   * Gets a string from the resource bundle and formats it with the argument
   * 
   * @param key
   *          the string used to get the bundle value, must not be null
   */
  public static String getFormattedString(String key, Object arg)
  {
    return MessageFormat.format(getString(key), new Object []{ arg });
  }

  /**
   * Gets a string from the resource bundle and formats it with arguments
   */
  public static String getFormattedString(String key, Object[] args)
  {
    return MessageFormat.format(getString(key), args);
  }

}